/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.listener.RepelHandler;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerTrackingSpawner
extends TickingSpawner {
    public final UUID playerUUID;
    protected BlockCollection collection;
    protected ArrayList<SpawnLocation> spawnLocations;
    protected ArrayList<SpawnAction<? extends Entity>> possibleSpawns = new ArrayList();
    public int minDistFromCentre = PixelmonConfig.minimumDistanceFromCentre;
    public int maxDistFromCentre = PixelmonConfig.maximumDistanceFromCentre;
    public float horizontalTrackFactor = PixelmonConfig.horizontalTrackFactor;
    public float verticalTrackFactor = PixelmonConfig.verticalTrackFactor;
    public int horizontalSliceRadius = PixelmonConfig.horizontalSliceRadius;
    public int verticalSliceRadius = PixelmonConfig.verticalSliceRadius;

    public PlayerTrackingSpawner(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public int getNumPasses() {
        return 2;
    }

    @Nullable
    public EntityPlayerMP getTrackedPlayer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
    }

    @Override
    public boolean shouldDoSpawning() {
        return super.shouldDoSpawning();
    }

    public boolean isTrackedPlayerOnline() {
        return this.getTrackedPlayer() != null;
    }

    @Override
    public ArrayList<SpawnAction<? extends Entity>> getSpawns(int pass) {
        if (pass == 0) {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
            if (player != null) {
                BlockPos centre = player.func_180425_c().func_177963_a((double)this.horizontalTrackFactor * player.field_70159_w, (double)this.verticalTrackFactor * player.field_70181_x, (double)this.horizontalTrackFactor * player.field_70179_y);
                float theta = RandomHelper.getRandomNumberBetween(0.0f, (float)Math.PI * 2);
                int r = RandomHelper.getRandomNumberBetween(this.minDistFromCentre, this.maxDistFromCentre);
                int x = centre.func_177958_n() + (int)((double)r * Math.cos(theta));
                int z = centre.func_177952_p() + (int)((double)r * Math.sin(theta));
                this.collection = new BlockCollection((World)player.func_71121_q(), x - this.horizontalSliceRadius, x + this.horizontalSliceRadius, centre.func_177956_o() - this.verticalSliceRadius, centre.func_177956_o() + this.verticalSliceRadius, z - this.horizontalSliceRadius, z + this.horizontalSliceRadius);
            }
            this.isBusy = true;
            PixelmonSpawning.coordinator.processor.addProcess(() -> {
                this.spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations(this.collection);
                Collections.shuffle(this.spawnLocations);
                this.possibleSpawns = this.calculateSpawnActions(this.spawnLocations);
                this.isBusy = false;
            });
            return null;
        }
        if (this.possibleSpawns == null || this.possibleSpawns.isEmpty()) {
            return null;
        }
        this.possibleSpawns.removeIf(action -> {
            if (!action.spawnLocation.location.world.func_175644_a(EntityPlayerMP.class, p -> RepelHandler.hasRepel(p.func_110124_au()) && p.func_180425_c().func_177951_i((Vec3i)action.spawnLocation.location.pos) < 5500.0).isEmpty()) {
                return true;
            }
            return !action.spawnLocation.location.world.func_175644_a(EntityLiving.class, entityLiving -> entityLiving.func_180425_c().func_185332_f(action.spawnLocation.location.pos.func_177958_n(), action.spawnLocation.location.pos.func_177956_o(), action.spawnLocation.location.pos.func_177952_p()) < (double)this.minDistBetweenSpawns).isEmpty();
        });
        return this.possibleSpawns;
    }

    public ArrayList<SpawnAction<? extends Entity>> calculateSpawnActions(ArrayList<SpawnLocation> spawnLocations) {
        ArrayList<SpawnAction<? extends Entity>> toSpawn = new ArrayList<SpawnAction<? extends Entity>>();
        HashMap<SpawnInfo, SpawnLocation> potentialSpawns = new HashMap<SpawnInfo, SpawnLocation>();
        HashMap<SpawnInfo, Float> adjustedRarities = new HashMap<SpawnInfo, Float>();
        for (SpawnLocation spawnLocation : spawnLocations) {
            SpawnInfo weightedSpawnInfo = this.getWeightedSpawnInfo(spawnLocation);
            if (weightedSpawnInfo == null) continue;
            float rarity = weightedSpawnInfo.getAdjustedRarity(spawnLocation);
            potentialSpawns.put(weightedSpawnInfo, spawnLocation);
            adjustedRarities.put(weightedSpawnInfo, Float.valueOf(rarity));
        }
        block1: while (!potentialSpawns.isEmpty() && this.hasCapacity(toSpawn.size() + 1) && toSpawn.size() <= this.spawnsPerPass) {
            float raritySum = 0.0f;
            for (Map.Entry entry : adjustedRarities.entrySet()) {
                raritySum += ((Float)entry.getValue()).floatValue();
            }
            float chosenSum = RandomHelper.getRandomNumberBetween(0.0f, raritySum);
            raritySum = 0.0f;
            Iterator it = adjustedRarities.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!potentialSpawns.containsKey(entry.getKey())) {
                    it.remove();
                    continue;
                }
                if (!((raritySum += ((Float)entry.getValue()).floatValue()) >= chosenSum)) continue;
                SpawnInfo spawn = (SpawnInfo)entry.getKey();
                SpawnLocation chosenLocation = (SpawnLocation)potentialSpawns.get(spawn);
                BlockPos.MutableBlockPos pos = chosenLocation.location.pos;
                toSpawn.add(spawn.construct(this, chosenLocation));
                it.remove();
                potentialSpawns.remove(spawn);
                potentialSpawns.values().removeIf(arg_0 -> this.lambda$calculateSpawnActions$4(chosenLocation, (BlockPos)pos, arg_0));
                continue block1;
            }
        }
        return toSpawn;
    }

    private /* synthetic */ boolean lambda$calculateSpawnActions$4(SpawnLocation chosenLocation, BlockPos pos, SpawnLocation spawnLocation) {
        if (spawnLocation.location.world != chosenLocation.location.world) {
            return false;
        }
        return !(spawnLocation.location.pos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) >= (double)this.minDistBetweenSpawns);
    }

    public static class PlayerTrackingSpawnerBuilder<T extends PlayerTrackingSpawner>
    extends TickingSpawner.TickingSpawnerBuilder<T> {
        protected int minDistFromCentre = PixelmonConfig.minimumDistanceFromCentre;
        protected int maxDistFromCentre = PixelmonConfig.maximumDistanceFromCentre;
        protected float horizontalTrackFactor = PixelmonConfig.horizontalTrackFactor;
        protected float verticalTrackFactor = PixelmonConfig.verticalTrackFactor;
        protected int horizontalSliceRadius = PixelmonConfig.horizontalSliceRadius;
        protected int verticalSliceRadius = PixelmonConfig.verticalSliceRadius;

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setDistanceFromCentre(int minimum, int maximum) {
            if (minimum < 0) {
                minimum = 0;
            }
            this.minDistFromCentre = minimum;
            if (maximum < 0) {
                maximum = 0;
            }
            this.maxDistFromCentre = maximum;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setTrackFactors(float horizontal, float vertical) {
            this.horizontalTrackFactor = horizontal;
            this.verticalTrackFactor = vertical;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setSliceRadii(int horizontal, int vertical) {
            if (horizontal < 1) {
                horizontal = 1;
            }
            this.horizontalSliceRadius = horizontal;
            if (vertical < 1) {
                vertical = 1;
            }
            this.verticalSliceRadius = vertical;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            super.apply(spawner);
            ((PlayerTrackingSpawner)spawner).minDistFromCentre = this.minDistFromCentre;
            ((PlayerTrackingSpawner)spawner).maxDistFromCentre = this.maxDistFromCentre;
            ((PlayerTrackingSpawner)spawner).verticalTrackFactor = this.verticalTrackFactor;
            ((PlayerTrackingSpawner)spawner).horizontalTrackFactor = this.horizontalTrackFactor;
            ((PlayerTrackingSpawner)spawner).verticalSliceRadius = this.verticalSliceRadius;
            ((PlayerTrackingSpawner)spawner).horizontalSliceRadius = this.horizontalSliceRadius;
            return spawner;
        }
    }
}

