/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.BossInfo;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.spawners.EntityData;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerTimed;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnerBoss
extends SpawnerTimed {
    public SpawnerBoss() {
        super(SpawnLocation.Boss);
    }

    @Override
    protected boolean isDisabled() {
        return PixelmonConfig.maxNumBosses <= 0;
    }

    @Override
    protected int getSpawnTickBase() {
        return PixelmonConfig.bossSpawnTicks;
    }

    @Override
    protected double getSpawnTickVariance() {
        return 0.6;
    }

    @Override
    public List<SpawnData> getEntityList(String biomeID) {
        return null;
    }

    @Override
    public EntityData getRandomEntity(World world, Random rand, String biomeID, BlockPos pos, int level) {
        ArrayList<BossInfo> bossSpawns = DropItemRegistry.getBossPokemon();
        if (bossSpawns.isEmpty()) {
            return null;
        }
        ArrayList<String> possibleSpawns = new ArrayList<String>();
        if (world.func_180495_p(new BlockPos(pos.func_177958_n(), this.getTopEarthBlock(world, pos, false) - 1, pos.func_177952_p())).func_185904_a() == Material.field_151586_h) {
            for (BossInfo b : bossSpawns) {
                if (b.spawnLocation != SpawnLocation.Water) continue;
                possibleSpawns.add(b.pokemon.name);
            }
        } else {
            for (BossInfo b : bossSpawns) {
                if (b.spawnLocation == SpawnLocation.Water) continue;
                possibleSpawns.add(b.pokemon.name);
            }
        }
        if (possibleSpawns.isEmpty()) {
            return null;
        }
        return new EntityData((String)RandomHelper.getRandomElementFromList(possibleSpawns), level);
    }

    @Override
    public void modifyPokemon(EntityLiving pokemon, int x, int z) {
        if (pokemon instanceof EntityPixelmon) {
            ((EntityPixelmon)pokemon).setBoss(EnumBossMode.getRandomMode());
        }
    }

    @Override
    public SpawnLocation getActualSpawnLocation(EntityPixelmon pokemon) {
        ArrayList<BossInfo> bossSpawns = DropItemRegistry.getBossPokemon();
        for (BossInfo b : bossSpawns) {
            if (b.pokemon != pokemon.baseStats.pokemon) continue;
            return b.spawnLocation;
        }
        return null;
    }

    @Override
    public int getMaxNum() {
        return PixelmonConfig.maxNumBosses;
    }
}

