/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityTurretChem
extends TileEntityTurret {
    public FluidTank tank = new FluidTank(4000);
    public boolean ignite = false;

    @Override
    protected double getRange() {
        return 8.0;
    }

    @Override
    protected boolean canActivate() {
        return this.tank.getFluidAmount() > 0 && this.energyStorage.getEnergyStored() >= Config.IEConfig.Machines.turret_chem_consumption;
    }

    @Override
    protected int getChargeupTicks() {
        return 10;
    }

    @Override
    protected int getActiveTicks() {
        return 1;
    }

    @Override
    protected boolean loopActivation() {
        return true;
    }

    @Override
    protected void activate() {
        FluidStack fs = this.tank.getFluid();
        if (fs != null && fs.getFluid() != null) {
            int consumed = Config.IEConfig.Tools.chemthrower_consumption;
            int energy = Config.IEConfig.Machines.turret_chem_consumption;
            if (consumed <= fs.amount && this.energyStorage.extractEnergy(energy, true) >= energy) {
                this.tank.drain(consumed, true);
                this.energyStorage.extractEnergy(energy, false);
                Vec3d v = this.getGunToTargetVec(this.target).func_72432_b();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float range = isGas ? 0.5f : 1.0f;
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && this.ignite;
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter);
                    Vec3d throwerPos = this.getGunPosition();
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(this.field_145850_b, throwerPos.field_72450_a + v.field_72450_a * 0.875, throwerPos.field_72448_b + v.field_72448_b * 0.875, throwerPos.field_72449_c + v.field_72449_c * 0.875, 0.0, 0.0, 0.0, fs);
                    chem.field_70159_w = vecDir.field_72450_a * (double)range;
                    chem.field_70181_x = vecDir.field_72448_b * (double)range;
                    chem.field_70179_y = vecDir.field_72449_c * (double)range;
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (this.field_145850_b.field_72995_K) continue;
                    this.field_145850_b.func_72838_d((Entity)chem);
                }
                if (this.tick % 4 == 0) {
                    if (ignite) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.sprayFire, SoundCategory.BLOCKS, 0.5f, 1.5f);
                    } else {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.spray, SoundCategory.BLOCKS, 0.5f, 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("ignite")) {
            this.ignite = message.func_74767_n("ignite");
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.ignite = nbt.func_74767_n("ignite");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("ignite", this.ignite);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.func_176734_d())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (!(this.dummy || capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || facing != null && facing != EnumFacing.DOWN && facing != this.facing.func_176734_d())) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }
}

