/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.apiculture.network.packets.PacketBeeLogicEntityRequest;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.entities.EntityMinecartContainerForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.GameProfileDataSerializer;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.IClimatised;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class EntityMinecartBeeHousingBase
extends EntityMinecartContainerForestry
implements IBeeHousing,
IOwnedTile,
IGuiBeeHousingDelegate,
IClimatised,
IStreamableGui {
    private static final DataParameter<Optional<GameProfile>> OWNER = EntityDataManager.func_187226_a(EntityMinecartBeeHousingBase.class, (DataSerializer)GameProfileDataSerializer.INSTANCE);
    private static final int beeFXInterval = 4;
    private static final int pollenFXInterval = 50;
    private final TickHelper tickHelper = new TickHelper();
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private final OwnerHandler ownerHandler = new OwnerHandler(){

        @Override
        public void setOwner(GameProfile owner) {
            super.setOwner(owner);
            EntityMinecartBeeHousingBase.this.field_70180_af.func_187227_b(OWNER, Optional.of(owner));
        }

        @Override
        public GameProfile getOwner() {
            Optional gameProfileOptional = (Optional)EntityMinecartBeeHousingBase.this.field_70180_af.func_187225_a(OWNER);
            return gameProfileOptional.orElse(null);
        }
    };
    private int breedingProgressPercent = 0;
    private boolean needsActiveUpdate = true;

    public EntityMinecartBeeHousingBase(World world) {
        super(world);
    }

    public EntityMinecartBeeHousingBase(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_70170_p, this.func_180425_c());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getBiome().func_76727_i());
    }

    @Override
    public float getExactTemperature() {
        return ClimateUtil.getTemperature(this.field_70170_p, this.func_180425_c());
    }

    @Override
    public float getExactHumidity() {
        return ClimateUtil.getHumidity(this.field_70170_p, this.func_180425_c());
    }

    @Override
    public int getBlockLightValue() {
        return this.field_70170_p.func_175671_l(this.func_180425_c().func_177984_a());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_70170_p.func_175710_j(this.func_180425_c().func_177984_a());
    }

    @Override
    public boolean isRaining() {
        return this.field_70170_p.func_175727_C(this.func_180425_c().func_177984_a());
    }

    @Override
    public World getWorldObj() {
        return this.field_70170_p;
    }

    @Override
    public Biome getBiome() {
        return this.field_70170_p.func_180494_b(this.func_180425_c());
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_180425_c();
    }

    @Override
    public Vec3d getBeeFXCoordinates() {
        return new Vec3d(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        data.func_150787_b(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(PacketBufferForestry data) {
        this.breedingProgressPercent = data.func_150792_a();
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickHelper.onTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.beeLogic.canWork()) {
                this.beeLogic.doWork();
            }
        } else {
            if (this.needsActiveUpdate) {
                PacketBeeLogicEntityRequest packet = new PacketBeeLogicEntityRequest((Entity)this);
                NetworkUtil.sendToServer(packet);
                this.needsActiveUpdate = false;
            }
            if (this.beeLogic.canDoBeeFX()) {
                if (this.tickHelper.updateOnInterval(4)) {
                    this.beeLogic.doBeeFX();
                }
                if (this.tickHelper.updateOnInterval(50)) {
                    TileBeeHousingBase.doPollenFX(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u - 0.1, this.field_70161_v - 0.5);
                }
            }
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.beeLogic.readFromNBT(nbtTagCompound);
        this.ownerHandler.readFromNBT(nbtTagCompound);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        this.beeLogic.writeToNBT(nbtTagCompound);
        this.ownerHandler.writeToNBT(nbtTagCompound);
    }
}

