/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.api.gui.GuiConstants;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IElementLayoutHelper;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IItemElement;
import forestry.api.gui.ILabelElement;
import forestry.api.gui.ITextElement;
import forestry.api.gui.style.ITextStyle;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.DrawableElement;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.LabelElement;
import forestry.core.gui.elements.SplitTextElement;
import forestry.core.gui.elements.layouts.AbstractElementLayout;
import forestry.core.gui.elements.layouts.ElementLayoutHelper;
import forestry.core.gui.elements.layouts.HorizontalLayout;
import forestry.core.gui.elements.layouts.PaneLayout;
import forestry.core.gui.elements.layouts.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ElementGroup
extends GuiElement
implements IElementGroup {
    protected final List<IGuiElement> elements = new ArrayList<IGuiElement>();

    protected ElementGroup(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    @Override
    public <E extends IGuiElement> E add(E element) {
        this.elements.add(element);
        element.setParent(this);
        element.onCreation();
        return element;
    }

    @Override
    public <E extends IGuiElement> E remove(E element) {
        this.elements.remove(element);
        element.onDeletion();
        return element;
    }

    @Override
    public void clear() {
        for (IGuiElement element : new ArrayList<IGuiElement>(this.elements)) {
            this.remove((E)element);
        }
    }

    @Override
    public List<IGuiElement> getElements() {
        return this.elements;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.forEach(element -> element.draw(mX, mY));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.onUpdateClient();
        for (IGuiElement widget : this.getElements()) {
            widget.updateClient();
        }
    }

    @Override
    @Nullable
    public IGuiElement getLastElement() {
        return this.elements.isEmpty() ? null : this.elements.get(this.elements.size() - 1);
    }

    public DrawableElement drawable(Drawable drawable) {
        return this.add((E)new DrawableElement(drawable));
    }

    public DrawableElement drawable(int x, int y, Drawable drawable) {
        return this.add((E)new DrawableElement(x, y, drawable));
    }

    @Override
    public IItemElement item(int xPos, int yPos, ItemStack itemStack) {
        ItemElement element = new ItemElement(xPos, yPos, itemStack);
        this.add((E)element);
        return element;
    }

    @Override
    public ILabelElement label(String text) {
        return this.label(text, GuiConstants.DEFAULT_STYLE);
    }

    @Override
    public ILabelElement label(String text, ITextStyle style) {
        return this.label(text, GuiElementAlignment.TOP_LEFT, style);
    }

    @Override
    public ILabelElement label(String text, GuiElementAlignment align) {
        return this.label(text, align, GuiConstants.DEFAULT_STYLE);
    }

    @Override
    public ILabelElement label(String text, GuiElementAlignment align, ITextStyle textStyle) {
        return this.label(text, -1, 12, align, textStyle);
    }

    @Override
    public ILabelElement label(String text, int width, int height, GuiElementAlignment align, ITextStyle textStyle) {
        return this.label(text, 0, 0, width, height, align, textStyle);
    }

    @Override
    public ILabelElement label(String text, int x, int y, int width, int height, GuiElementAlignment align, ITextStyle textStyle) {
        return this.add((E)new LabelElement(x, y, width, height, text, align, textStyle));
    }

    @Override
    public ITextElement splitText(String text, int width) {
        return this.splitText(text, width, GuiConstants.DEFAULT_STYLE);
    }

    @Override
    public ITextElement splitText(String text, int width, ITextStyle textStyle) {
        return this.splitText(text, width, GuiElementAlignment.TOP_LEFT, textStyle);
    }

    @Override
    public ITextElement splitText(String text, int width, GuiElementAlignment align, ITextStyle textStyle) {
        return this.splitText(text, 0, 0, width, align, textStyle);
    }

    @Override
    public ITextElement splitText(String text, int x, int y, int width, GuiElementAlignment align, ITextStyle textStyle) {
        return this.add((E)new SplitTextElement(x, y, width, text, align, textStyle));
    }

    @Override
    public AbstractElementLayout vertical(int xPos, int yPos, int width) {
        return this.add((E)new VerticalLayout(xPos, yPos, width));
    }

    @Override
    public AbstractElementLayout vertical(int width) {
        return this.add((E)new VerticalLayout(0, 0, width));
    }

    @Override
    public AbstractElementLayout horizontal(int xPos, int yPos, int height) {
        return this.add((E)new HorizontalLayout(xPos, yPos, height));
    }

    @Override
    public AbstractElementLayout horizontal(int height) {
        return this.add((E)new HorizontalLayout(0, 0, height));
    }

    @Override
    public ElementGroup pane(int xPos, int yPos, int width, int height) {
        return this.add((E)new PaneLayout(xPos, yPos, width, height));
    }

    @Override
    public ElementGroup pane(int width, int height) {
        return this.add((E)new PaneLayout(0, 0, width, height));
    }

    @Override
    public ElementLayoutHelper layoutHelper(IElementLayoutHelper.LayoutFactory layoutFactory, int width, int height) {
        return new ElementLayoutHelper(layoutFactory, width, height, this);
    }
}

