/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.layouts.AbstractElementLayout;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VerticalLayout
extends AbstractElementLayout {
    public VerticalLayout(int width) {
        this(0, 0, width);
    }

    public VerticalLayout(int xPos, int yPos, int width) {
        super(xPos, yPos, width, 0);
    }

    @Override
    public <E extends IGuiElement> E add(E element) {
        this.elements.add(element);
        element.setParent(this);
        element.setYPosition(this.height);
        this.setHeight(this.height + (element.getHeight() + this.distance));
        element.onCreation();
        return element;
    }

    @Override
    public <E extends IGuiElement> E remove(E element) {
        this.elements.remove(element);
        this.setHeight(this.height - (element.getHeight() + this.distance));
        element.setYPosition(0);
        element.onDeletion();
        return element;
    }

    public void layout() {
        this.height = 0;
        for (IGuiElement element : this.elements) {
            element.setYPosition(this.height);
            this.setHeight(this.height + (element.getHeight() + this.distance));
        }
    }

    @Override
    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        int width = 0;
        for (IGuiElement element : this.elements) {
            int elementWidth = element.getWidth();
            if (elementWidth <= width) continue;
            width = elementWidth;
        }
        return width;
    }
}

