/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.api.greenhouse.Position2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class ClimateSourceWorldManager {
    private final Map<Position2D, Map<Integer, IClimateSourceOwner>> owners = new HashMap<Position2D, Map<Integer, IClimateSourceOwner>>();

    public void addSource(IClimateSourceOwner owner) {
        BlockPos pos = owner.getCoordinates();
        Position2D position = new Position2D((Vec3i)pos);
        Map positionedOwners = this.owners.computeIfAbsent(position, k -> new HashMap());
        positionedOwners.put(pos.func_177956_o(), owner);
    }

    public void removeSource(IClimateSourceOwner owner) {
        BlockPos pos = owner.getCoordinates();
        Position2D position = new Position2D((Vec3i)pos);
        Map positionedOwners = this.owners.computeIfAbsent(position, k -> new HashMap());
        positionedOwners.remove(pos.func_177956_o());
    }

    public Collection<IClimateSourceOwner> getSources(Position2D position) {
        Map<Integer, IClimateSourceOwner> positionedOwners = this.owners.get(position);
        if (positionedOwners == null) {
            return Collections.emptyList();
        }
        return positionedOwners.values();
    }
}

