/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui.widgets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.greenhouse.gui.widgets.WidgetCamouflageSlot;
import forestry.greenhouse.multiblock.GreenhouseController;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class WidgetCamouflageTab
extends Widget {
    public static final int WIDTH = 68;
    public static final int HEIGHT = 25;
    private final WidgetCamouflageSlot greenhouseSlot;
    @Nullable
    private final WidgetCamouflageSlot handlerSlot;
    private final ItemStack typeStack;

    public WidgetCamouflageTab(WidgetManager manager, int xPos, int yPos, IGreenhouseController controller, ICamouflageHandler camouflageHandler) {
        super(manager, xPos, yPos);
        this.width = 68;
        this.height = 25;
        this.greenhouseSlot = new WidgetCamouflageSlot(manager, xPos + 26, yPos + 6, controller);
        this.handlerSlot = new WidgetCamouflageSlot(manager, xPos + 46, yPos + 6, camouflageHandler);
        this.typeStack = GreenhouseController.createDefaultCamouflageBlock();
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 196, 0, 48, 25);
        if (this.handlerSlot != null) {
            this.manager.gui.func_73729_b(startX + this.xPos + 44, startY + this.yPos, 196, 25, 24, 25);
        }
        if (!this.typeStack.func_190926_b()) {
            textureManager.func_110577_a(TextureMap.field_110575_b);
            RenderItem renderItem = minecraft.func_175599_af();
            renderItem.func_175042_a(this.typeStack, startX + this.xPos + 6, startY + this.yPos + 6);
        }
        this.greenhouseSlot.draw(startX, startY);
        if (this.handlerSlot != null) {
            this.handlerSlot.draw(startX, startY);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.greenhouseSlot.isMouseOver(mouseX, mouseY)) {
            return this.greenhouseSlot.getToolTip(mouseX, mouseY);
        }
        if (this.handlerSlot != null && this.handlerSlot.isMouseOver(mouseX, mouseY)) {
            return this.handlerSlot.getToolTip(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.greenhouseSlot.isMouseOver(mouseX -= this.manager.gui.getGuiLeft(), mouseY -= this.manager.gui.getGuiTop())) {
            this.greenhouseSlot.handleMouseClick(mouseX, mouseY, mouseButton);
        } else if (this.handlerSlot != null && this.handlerSlot.isMouseOver(mouseX, mouseY)) {
            this.handlerSlot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        return this.isMouseOver(mouseX, mouseY);
    }

    @Nullable
    public WidgetCamouflageSlot getHandlerSlot() {
        return this.handlerSlot;
    }
}

