/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.textures.mixins.client;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.dimdev.vanillafix.textures.IPatchedCompiledChunk;
import org.dimdev.vanillafix.textures.IPatchedTextureAtlasSprite;
import org.dimdev.vanillafix.textures.TemporaryStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModelRenderer.class})
public class MixinBlockModelRenderer {
    @Inject(method={"renderModel(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z"}, at={@At(value="HEAD")})
    private void beforeRenderModel(IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand, CallbackInfoReturnable<Boolean> ci) {
        CompiledChunk compiledChunk = TemporaryStorage.currentCompiledChunk.get(Thread.currentThread().getId());
        Set<TextureAtlasSprite> visibleTextures = compiledChunk != null ? ((IPatchedCompiledChunk)compiledChunk).getVisibleTextures() : new HashSet<TextureAtlasSprite>();
        for (EnumFacing side : EnumFacing.values()) {
            List quads;
            if (checkSides && !state.func_185894_c(world, pos, side) || (quads = model.func_188616_a(state, side, rand)) == null) continue;
            for (BakedQuad quad : quads) {
                if (quad == null || quad.func_187508_a() == null) continue;
                visibleTextures.add(quad.func_187508_a());
            }
        }
        List quads = model.func_188616_a(state, null, rand);
        if (quads != null) {
            for (BakedQuad quad : quads) {
                if (quad == null || quad.func_187508_a() == null) continue;
                visibleTextures.add(quad.func_187508_a());
            }
        }
        if (compiledChunk == null) {
            for (TextureAtlasSprite texture : visibleTextures) {
                ((IPatchedTextureAtlasSprite)texture).markNeedsAnimationUpdate();
            }
        }
    }
}

