/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IEnergyContainer;
import java.util.List;
import net.minecraft.util.EnumFacing;

public class EnergyContainerList
implements IEnergyContainer {
    private List<IEnergyContainer> energyContainerList;

    public EnergyContainerList(List<IEnergyContainer> energyContainerList) {
        this.energyContainerList = energyContainerList;
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        long amperesUsed = 0L;
        for (IEnergyContainer energyContainer : this.energyContainerList) {
            if (amperage == (amperesUsed += energyContainer.acceptEnergyFromNetwork(null, voltage, amperage))) break;
        }
        return amperesUsed;
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long energyAdded = 0L;
        for (IEnergyContainer energyContainer : this.energyContainerList) {
            if ((energyAdded += energyContainer.changeEnergy(energyToAdd - energyAdded)) == energyToAdd) break;
        }
        return energyAdded;
    }

    @Override
    public long getEnergyStored() {
        return this.energyContainerList.stream().mapToLong(IEnergyContainer::getEnergyStored).sum();
    }

    @Override
    public long getEnergyCapacity() {
        return this.energyContainerList.stream().mapToLong(IEnergyContainer::getEnergyCapacity).sum();
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        return this.energyContainerList.stream().mapToLong(v -> v.getInputVoltage() * v.getInputAmperage()).sum();
    }

    @Override
    public long getOutputVoltage() {
        return this.energyContainerList.stream().mapToLong(v -> v.getOutputVoltage() * v.getOutputAmperage()).sum();
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return true;
    }
}

