/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.AbstractPositionedWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedTextWidget
extends AbstractPositionedWidget {
    protected int maxWidthLimit;
    protected Consumer<List<ITextComponent>> textSupplier;
    private ArrayList<ITextComponent> lastText = new ArrayList();
    private int color;

    public AdvancedTextWidget(int xPosition, int yPosition, Consumer<List<ITextComponent>> text, int color) {
        super(xPosition, yPosition);
        this.textSupplier = text;
        this.color = color;
    }

    public AdvancedTextWidget setMaxWidthLimit(int maxWidthLimit) {
        this.maxWidthLimit = maxWidthLimit;
        return this;
    }

    @Override
    public void detectAndSendChanges() {
        ArrayList textBuffer = new ArrayList();
        this.textSupplier.accept(textBuffer);
        if (!this.lastText.equals(textBuffer)) {
            this.lastText = textBuffer;
            this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(this.lastText.size());
                for (ITextComponent textComponent : this.lastText) {
                    buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent));
                }
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.lastText.clear();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                String jsonText = buffer.func_150789_c(Short.MAX_VALUE);
                this.lastText.add(ITextComponent.Serializer.func_150699_a((String)jsonText));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List<Object> cutText = this.maxWidthLimit > 0 ? this.lastText.stream().flatMap(c -> GuiUtilRenderComponents.func_178908_a((ITextComponent)c, (int)this.maxWidthLimit, (FontRenderer)fontRenderer, (boolean)true, (boolean)true).stream()).collect(Collectors.toList()) : this.lastText;
        for (int i = 0; i < cutText.size(); ++i) {
            fontRenderer.func_78276_b(((ITextComponent)cutText.get(i)).func_150254_d(), this.xPosition, this.yPosition + i * (fontRenderer.field_78288_b + 2), this.color);
        }
    }
}

