/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.metaitem.MetaItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ArmorMetaItem
extends MetaItem<ArmorMetaValueItem>
implements ISpecialArmor {
    public ArmorMetaItem(short metaItemOffset) {
        super(metaItemOffset);
    }

    @Override
    protected ArmorMetaValueItem constructMetaValueItem(short metaValue, String unlocalizedName) {
        return new ArmorMetaValueItem((int)metaValue, unlocalizedName);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        ArmorMetaValueItem valueItem = (ArmorMetaValueItem)this.getItem(stack);
        return valueItem != null && valueItem.getEquipmentSlot() == armorType;
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        ArmorMetaValueItem valueItem = (ArmorMetaValueItem)this.getItem(stack);
        return valueItem == null ? null : valueItem.getEquipmentSlot();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        IArmorLogic armorLogic;
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(itemStack);
        IArmorLogic iArmorLogic = armorLogic = metaValueItem == null ? null : metaValueItem.getArmorLogic();
        if (armorLogic != null) {
            armorLogic.onArmorTick(world, player, itemStack);
        }
    }

    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        IArmorLogic armorLogic;
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(stack);
        IArmorLogic iArmorLogic = armorLogic = metaValueItem == null ? null : metaValueItem.getArmorLogic();
        if (armorLogic != null) {
            armorLogic.renderHelmetOverlay(stack, player, resolution, partialTicks);
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        IArmorLogic armorLogic;
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(armor);
        IArmorLogic iArmorLogic = armorLogic = metaValueItem == null ? null : metaValueItem.getArmorLogic();
        if (armorLogic != null) {
            return armorLogic.getArmorProperties(player, armor, source, damage, EntityEquipmentSlot.values()[slot]);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        IArmorLogic armorLogic;
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(armor);
        IArmorLogic iArmorLogic = armorLogic = metaValueItem == null ? null : metaValueItem.getArmorLogic();
        if (armorLogic != null) {
            armorLogic.getArmorDisplay(player, armor, EntityEquipmentSlot.values()[slot]);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        IArmorLogic armorLogic;
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(stack);
        IArmorLogic iArmorLogic = armorLogic = metaValueItem == null ? null : metaValueItem.getArmorLogic();
        if (armorLogic != null) {
            armorLogic.damageArmor(entity, stack, source, damage, EntityEquipmentSlot.values()[slot]);
        }
    }

    public class ArmorMetaValueItem
    extends MetaItem.MetaValueItem {
        private EntityEquipmentSlot equipmentSlot;
        private IArmorLogic armorLogic;

        public ArmorMetaValueItem(int metaValue, String unlocalizedName) {
            super(ArmorMetaItem.this, metaValue, unlocalizedName);
        }

        public EntityEquipmentSlot getEquipmentSlot() {
            return this.equipmentSlot;
        }

        public IArmorLogic getArmorLogic() {
            return this.armorLogic;
        }

        public ArmorMetaValueItem setEquipmentSlot(EntityEquipmentSlot equipmentSlot) {
            this.equipmentSlot = equipmentSlot;
            return this;
        }

        public ArmorMetaValueItem setArmorLogic(IArmorLogic armorLogic) {
            this.armorLogic = armorLogic;
            return this;
        }
    }
}

