/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.model;

import gregtech.api.model.ResourcePackHook;
import gregtech.api.util.FileUtility;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractBlockModelFactory
implements ResourcePackHook.IResourcePackFileHook {
    private final ResourceLocation sampleResourceLocation;
    private final String blockNamePrefix;
    private String blockStateSample;

    public AbstractBlockModelFactory(String sampleName, String blockNamePrefix) {
        this.sampleResourceLocation = sampleName == null ? null : new ResourceLocation("gregtech", "blockstates/autogenerated/" + sampleName + ".json");
        this.blockNamePrefix = blockNamePrefix;
    }

    protected abstract String fillSample(Block var1, String var2);

    @Override
    public void onResourceManagerReload(SimpleReloadableResourceManager resourceManager) {
        if (this.sampleResourceLocation != null) {
            try {
                this.blockStateSample = FileUtility.readInputStream(resourceManager.func_110536_a(this.sampleResourceLocation).func_110527_b());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public boolean resourceExists(ResourceLocation location) {
        return location.func_110624_b().equals("gregtech") && location.func_110623_a().startsWith("blockstates/" + this.blockNamePrefix) && !location.func_110623_a().contains(".mcmeta");
    }

    @Override
    public InputStream getInputStream(ResourceLocation location) throws IOException {
        String resourcePath = location.func_110623_a();
        resourcePath = resourcePath.substring(0, resourcePath.length() - 5);
        if ((resourcePath = resourcePath.substring(12)).startsWith(this.blockNamePrefix)) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(location.func_110624_b(), resourcePath));
            if (block != null && block != Blocks.field_150350_a) {
                return FileUtility.writeInputStream(this.fillSample(block, this.blockStateSample));
            }
            throw new IllegalArgumentException("Block not found: " + resourcePath);
        }
        throw new FileNotFoundException(location.toString());
    }
}

