/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multiblock;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.IPatternCenterPredicate;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.util.IntRange;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPattern {
    private final Predicate<BlockWorldState>[][][] blockMatches;
    private final TIntObjectMap<Predicate<PatternMatchContext>> layerMatchers = new TIntObjectHashMap();
    private final Predicate<PatternMatchContext>[] validators;
    private final int fingerLength;
    private final int thumbLength;
    private final int palmLength;
    private final RelativeDirection[] structureDir;
    private final int[][] aisleRepetitions;
    private final Pair<Predicate<BlockWorldState>, IntRange>[] countMatches;
    private int[] centerOffset = null;
    private final BlockWorldState worldState = new BlockWorldState();
    private final BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    private final PatternMatchContext matchContext = new PatternMatchContext();
    private final PatternMatchContext layerContext = new PatternMatchContext();

    public BlockPattern(Predicate<BlockWorldState>[][][] predicatesIn, List<Pair<Predicate<BlockWorldState>, IntRange>> countMatches, TIntObjectMap<Predicate<PatternMatchContext>> layerMatchers, List<Predicate<PatternMatchContext>> validators, RelativeDirection[] structureDir, int[][] aisleRepetitions) {
        this.blockMatches = predicatesIn;
        this.countMatches = countMatches.toArray(new Pair[0]);
        this.layerMatchers.putAll(layerMatchers);
        this.validators = validators.toArray(new Predicate[0]);
        this.fingerLength = predicatesIn.length;
        if (this.fingerLength > 0) {
            this.thumbLength = predicatesIn[0].length;
            this.palmLength = this.thumbLength > 0 ? predicatesIn[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
        this.structureDir = structureDir;
        this.aisleRepetitions = aisleRepetitions;
        this.initializeCenterOffsets();
    }

    private void initializeCenterOffsets() {
        block0: for (int x = 0; x < this.palmLength; ++x) {
            for (int y = 0; y < this.thumbLength; ++y) {
                int minZ = 0;
                int maxZ = 0;
                for (int z = 0; z < this.fingerLength; ++z) {
                    Predicate<BlockWorldState> predicate = this.blockMatches[z][y][x];
                    if (predicate instanceof IPatternCenterPredicate) {
                        this.centerOffset = new int[]{x, y, z, minZ, maxZ};
                        break block0;
                    }
                    minZ += this.aisleRepetitions[z][0];
                    maxZ += this.aisleRepetitions[z][1];
                }
            }
        }
        if (this.centerOffset == null) {
            throw new IllegalArgumentException("Didn't found center predicate");
        }
    }

    public int getFingerLength() {
        return this.fingerLength;
    }

    public int getThumbLength() {
        return this.thumbLength;
    }

    public int getPalmLength() {
        return this.palmLength;
    }

    public PatternMatchContext checkPatternAt(World world, BlockPos centerPos, EnumFacing facing) {
        int[] countMatchesCache = new int[this.countMatches.length];
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        this.matchContext.reset();
        this.layerContext.reset();
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block12: {
                    this.layerContext.reset();
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.thumbLength) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.palmLength) {
                            Predicate<BlockWorldState> predicate = this.blockMatches[c][b][a];
                            this.setActualRelativeOffset(this.blockPos, x, y, z, facing);
                            this.blockPos.func_181079_c(this.blockPos.func_177958_n() + centerPos.func_177958_n(), this.blockPos.func_177956_o() + centerPos.func_177956_o(), this.blockPos.func_177952_p() + centerPos.func_177952_p());
                            this.worldState.update(world, (BlockPos)this.blockPos, this.matchContext, this.layerContext);
                            if (!predicate.test(this.worldState)) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        this.matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block12;
                            }
                            for (int i = 0; i < countMatchesCache.length; ++i) {
                                if (!((Predicate)this.countMatches[i].getLeft()).test(this.worldState)) continue;
                                int n = i;
                                countMatchesCache[n] = countMatchesCache[n] + 1;
                            }
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    findFirstAisle = true;
                    ++z;
                    Predicate layerPredicate = (Predicate)this.layerMatchers.get(c);
                    if (layerPredicate != null && !layerPredicate.test(this.layerContext)) {
                        return null;
                    }
                }
                ++r;
            }
            if (r >= this.aisleRepetitions[c][0]) continue;
            return null;
        }
        for (int i = 0; i < countMatchesCache.length; ++i) {
            IntRange intRange = (IntRange)this.countMatches[i].getRight();
            if (intRange.isInsideOf(countMatchesCache[i])) continue;
            return null;
        }
        for (Predicate<PatternMatchContext> validator : this.validators) {
            if (validator.test(this.matchContext)) continue;
            return null;
        }
        return this.matchContext;
    }

    private BlockPos.MutableBlockPos setActualRelativeOffset(BlockPos.MutableBlockPos pos, int x, int y, int z, EnumFacing facing) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        block8: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i].getActualFacing(facing)) {
                case UP: {
                    c1[1] = c0[i];
                    continue block8;
                }
                case DOWN: {
                    c1[1] = -c0[i];
                    continue block8;
                }
                case WEST: {
                    c1[0] = -c0[i];
                    continue block8;
                }
                case EAST: {
                    c1[0] = c0[i];
                    continue block8;
                }
                case NORTH: {
                    c1[2] = -c0[i];
                    continue block8;
                }
                case SOUTH: {
                    c1[2] = c0[i];
                }
            }
        }
        return pos.func_181079_c(c1[0], c1[1], c1[2]);
    }

    public static enum RelativeDirection {
        UP(f -> EnumFacing.UP),
        DOWN(f -> EnumFacing.DOWN),
        LEFT(EnumFacing::func_176735_f),
        RIGHT(EnumFacing::func_176746_e),
        FRONT(Function.identity()),
        BACK(EnumFacing::func_176734_d);

        Function<EnumFacing, EnumFacing> actualFacing;

        private RelativeDirection(Function<EnumFacing, EnumFacing> actualFacing) {
            this.actualFacing = actualFacing;
        }

        public EnumFacing getActualFacing(EnumFacing facing) {
            return this.actualFacing.apply(facing);
        }
    }
}

