/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class RecipeBuilder<R extends RecipeBuilder<R>> {
    protected RecipeMap<R> recipeMap;
    protected List<CountableIngredient> inputs;
    protected NonNullList<ItemStack> outputs;
    protected TObjectIntMap<ItemStack> chancedOutputs;
    protected List<FluidStack> fluidInputs;
    protected List<FluidStack> fluidOutputs;
    protected int duration;
    protected int EUt;
    protected boolean hidden = false;
    protected boolean needsEmptyOutput = false;
    protected EnumValidationResult recipeStatus = EnumValidationResult.VALID;

    protected RecipeBuilder() {
        this.inputs = NonNullList.func_191196_a();
        this.outputs = NonNullList.func_191196_a();
        this.chancedOutputs = new TObjectIntHashMap(0);
        this.fluidInputs = new ArrayList<FluidStack>(0);
        this.fluidOutputs = new ArrayList<FluidStack>(0);
    }

    protected RecipeBuilder(Recipe recipe, RecipeMap<R> recipeMap) {
        this.recipeMap = recipeMap;
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(recipe.getInputs());
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll(GTUtility.copyStackList(recipe.getOutputs()));
        this.chancedOutputs = new TObjectIntHashMap();
        recipe.getChancedOutputs().forEachEntry((key, value) -> {
            this.chancedOutputs.put((Object)key.func_77946_l(), value);
            return true;
        });
        this.fluidInputs = GTUtility.copyFluidList(recipe.getFluidInputs());
        this.fluidOutputs = GTUtility.copyFluidList(recipe.getFluidOutputs());
        this.duration = recipe.getDuration();
        this.EUt = recipe.getEUt();
        this.hidden = recipe.isHidden();
        this.needsEmptyOutput = recipe.needsEmptyOutput();
    }

    protected RecipeBuilder(RecipeBuilder<R> recipeBuilder) {
        this.recipeMap = recipeBuilder.recipeMap;
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(recipeBuilder.getInputs());
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll(GTUtility.copyStackList(recipeBuilder.getOutputs()));
        this.chancedOutputs = new TObjectIntHashMap();
        recipeBuilder.getChancedOutputs().forEachEntry((key, value) -> {
            this.chancedOutputs.put((Object)key.func_77946_l(), value);
            return true;
        });
        this.fluidInputs = GTUtility.copyFluidList(recipeBuilder.getFluidInputs());
        this.fluidOutputs = GTUtility.copyFluidList(recipeBuilder.getFluidOutputs());
        this.duration = recipeBuilder.duration;
        this.EUt = recipeBuilder.EUt;
        this.hidden = recipeBuilder.hidden;
        this.needsEmptyOutput = recipeBuilder.needsEmptyOutput;
    }

    public boolean applyProperty(String key, Object value) {
        return false;
    }

    public R inputs(ItemStack ... inputs) {
        return this.inputs(Arrays.asList(inputs));
    }

    public R inputs(Collection<ItemStack> inputs) {
        if (GTUtility.iterableContains(inputs, stack -> stack == null || stack.func_190926_b())) {
            GTLog.logger.error("Input cannot contain null or empty ItemStacks. Inputs: {}", inputs);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        inputs.forEach(stack -> {
            if (stack != null && !stack.func_190926_b()) {
                this.inputs.add(CountableIngredient.from(stack));
            }
        });
        return (R)this;
    }

    public R input(String oredict, int count) {
        return this.inputs(CountableIngredient.from(oredict, count));
    }

    public R input(OrePrefix orePrefix, Material material) {
        return this.inputs(CountableIngredient.from(orePrefix, material, 1));
    }

    public R input(OrePrefix orePrefix, Material material, int count) {
        return this.inputs(CountableIngredient.from(orePrefix, material, count));
    }

    public R inputs(CountableIngredient ... inputs) {
        ArrayList<CountableIngredient> ingredients = new ArrayList<CountableIngredient>();
        for (CountableIngredient input : inputs) {
            if (input.getCount() < 0) {
                GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)input.getCount());
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                continue;
            }
            ingredients.add(input);
        }
        return this.inputsIngredients(ingredients);
    }

    public R inputsIngredients(Collection<CountableIngredient> ingredients) {
        this.inputs.addAll(ingredients);
        return (R)this;
    }

    public R notConsumable(ItemStack itemStack) {
        return this.inputs(CountableIngredient.from(itemStack, 0));
    }

    public R notConsumable(OrePrefix prefix, Material material) {
        return this.input(prefix, material, 0);
    }

    public R notConsumable(Ingredient ingredient) {
        return this.inputs(new CountableIngredient(ingredient, 0));
    }

    public R notConsumable(MetaItem.MetaValueItem item) {
        return this.inputs(CountableIngredient.from(item.getStackForm(), 0));
    }

    public R outputs(ItemStack ... outputs) {
        return this.outputs(Arrays.asList(outputs));
    }

    public R outputs(Collection<ItemStack> outputs) {
        outputs = new ArrayList<ItemStack>(outputs);
        outputs.removeIf(stack -> stack == null || stack.func_190926_b());
        this.outputs.addAll(outputs);
        return (R)this;
    }

    public R fluidInputs(FluidStack ... inputs) {
        return this.fluidInputs(Arrays.asList(inputs));
    }

    public R fluidInputs(Collection<FluidStack> inputs) {
        if (inputs.contains(null)) {
            GTLog.logger.error("Fluid input cannot contain null FluidStacks. Inputs: {}", inputs);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.fluidInputs.addAll(inputs);
        this.fluidInputs.removeIf(Objects::isNull);
        return (R)this;
    }

    public R fluidOutputs(FluidStack ... outputs) {
        return this.fluidOutputs(Arrays.asList(outputs));
    }

    public R fluidOutputs(Collection<FluidStack> outputs) {
        outputs = new ArrayList<FluidStack>(outputs);
        outputs.removeIf(Objects::isNull);
        this.fluidOutputs.addAll(outputs);
        return (R)this;
    }

    public R chancedOutput(ItemStack stack, int chance, int tierChanceBoost) {
        if (stack == null || stack.func_190926_b()) {
            return (R)this;
        }
        if (0 >= chance || chance > Recipe.getMaxChancedValue()) {
            GTLog.logger.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", (Object)Recipe.getMaxChancedValue(), (Object)chance);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
            return (R)this;
        }
        this.chancedOutputs.put((Object)stack, chance);
        return (R)this;
    }

    public R duration(int duration) {
        this.duration = duration;
        return (R)this;
    }

    public R EUt(int EUt) {
        this.EUt = EUt;
        return (R)this;
    }

    public R hidden() {
        this.hidden = true;
        return (R)this;
    }

    public R needsEmptyOutput() {
        this.needsEmptyOutput = true;
        return (R)this;
    }

    public R setRecipeMap(RecipeMap<R> recipeMap) {
        this.recipeMap = recipeMap;
        return (R)this;
    }

    public R fromRecipe(Recipe recipe) {
        this.inputs = recipe.getInputs();
        this.outputs = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])recipe.getOutputs().toArray((Object[])new ItemStack[0]));
        this.chancedOutputs = new TObjectIntHashMap(recipe.getChancedOutputs());
        this.fluidInputs = new ArrayList<FluidStack>(recipe.getFluidInputs());
        this.fluidOutputs = new ArrayList<FluidStack>(recipe.getFluidOutputs());
        this.duration = recipe.getDuration();
        this.EUt = recipe.getEUt();
        this.hidden = recipe.isHidden();
        this.needsEmptyOutput = recipe.needsEmptyOutput();
        return (R)this;
    }

    public abstract R copy();

    protected EnumValidationResult finalizeAndValidate() {
        return this.validate();
    }

    public abstract ValidationResult<Recipe> build();

    protected EnumValidationResult validate() {
        if (this.recipeMap == null) {
            GTLog.logger.error("RecipeMap cannot be null", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.recipeMap.getMinInputs(), this.recipeMap.getMaxInputs(), this.inputs.size())) {
            GTLog.logger.error("Invalid amount of recipe inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.inputs.size(), (Object)this.recipeMap.getMinInputs(), (Object)this.recipeMap.getMaxInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.recipeMap.getMinOutputs(), this.recipeMap.getMaxOutputs(), this.outputs.size() + this.chancedOutputs.size())) {
            GTLog.logger.error("Invalid amount of recipe outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)(this.outputs.size() + this.chancedOutputs.size()), (Object)this.recipeMap.getMinOutputs(), (Object)this.recipeMap.getMaxOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.recipeMap.getMinFluidInputs(), this.recipeMap.getMaxFluidInputs(), this.fluidInputs.size())) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.fluidInputs.size(), (Object)this.recipeMap.getMinFluidInputs(), (Object)this.recipeMap.getMaxFluidInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.recipeMap.getMinFluidOutputs(), this.recipeMap.getMaxFluidOutputs(), this.fluidOutputs.size())) {
            GTLog.logger.error("Invalid amount of recipe fluid outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.fluidOutputs.size(), (Object)this.recipeMap.getMinFluidOutputs(), (Object)this.recipeMap.getMaxFluidOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.EUt == 0) {
            GTLog.logger.error("EU/t cannot be equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.duration <= 0) {
            GTLog.logger.error("Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.recipeStatus == EnumValidationResult.INVALID) {
            GTLog.logger.error("Invalid recipe, read the errors above: {}", (Object)this);
        }
        return this.recipeStatus;
    }

    public void buildAndRegister() {
        this.recipeMap.addRecipe(this.build());
    }

    public List<CountableIngredient> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public TObjectIntMap<ItemStack> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("recipeMap", this.recipeMap).append("inputs", this.inputs).append("outputs", this.outputs).append("chancedOutputs", this.chancedOutputs).append("fluidInputs", this.fluidInputs).append("fluidOutputs", this.fluidOutputs).append("duration", this.duration).append("EUt", this.EUt).append("hidden", this.hidden).append("needsEmptyOutput", this.needsEmptyOutput).append("recipeStatus", (Object)this.recipeStatus).toString();
    }
}

