/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class LargeTurbineRenderer
implements TextureUtils.IIconRegister {
    private static final Cuboid6 BIG_CUBOID = new Cuboid6(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite baseRingSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite baseBackgroundSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite idleBladeSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite activeBladeSprite;

    public LargeTurbineRenderer() {
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.baseRingSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/multiblock/large_turbine/base_ring"));
        this.baseBackgroundSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/multiblock/large_turbine/base_bg"));
        this.idleBladeSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/multiblock/large_turbine/rotor_idle"));
        this.activeBladeSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/multiblock/large_turbine/rotor_spinning"));
    }

    public void renderSided(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing side, boolean hasBase, boolean hasRotor, boolean isActive, int rotorRGB) {
        Matrix4 cornerOffset = null;
        switch (side.func_176740_k()) {
            case X: {
                cornerOffset = translation.copy().translate(0.01 * (double)side.func_82601_c(), -1.0, -1.0);
                cornerOffset.scale(1.0, 3.0, 3.0);
                break;
            }
            case Z: {
                cornerOffset = translation.copy().translate(-1.0, -1.0, 0.01 * (double)side.func_82599_e());
                cornerOffset.scale(3.0, 3.0, 1.0);
                break;
            }
            case Y: {
                cornerOffset = translation.copy().translate(-1.0, 0.01 * (double)side.func_96559_d(), -1.0);
                cornerOffset.scale(3.0, 1.0, 3.0);
            }
        }
        if (hasBase) {
            Textures.renderFace(renderState, cornerOffset, pipeline, side, Cuboid6.full, this.baseRingSprite);
            renderState.brightness = 0xF000F0;
            renderState.colour = -1;
            Textures.renderFace(renderState, cornerOffset, new IVertexOperation[0], side, Cuboid6.full, this.baseBackgroundSprite);
        }
        if (hasRotor) {
            TextureAtlasSprite sprite = isActive ? this.activeBladeSprite : this.idleBladeSprite;
            IVertexOperation[] color = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(rotorRGB)));
            Textures.renderFace(renderState, cornerOffset, color, side, Cuboid6.full, sprite);
        }
    }
}

