/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render.scene;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import gregtech.api.gui.resources.RenderUtil;
import gregtech.api.render.scene.SceneRenderCallback;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.world.DummyWorld;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class WorldSceneRenderer {
    private static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    private static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final TrackedDummyWorld world = new TrackedDummyWorld();
    private final List<BlockPos> renderedBlocks = new ArrayList<BlockPos>();
    private SceneRenderCallback renderCallback;
    private Predicate<BlockPos> renderFilter;
    private BlockPos lastHitBlock;

    public WorldSceneRenderer(Map<BlockPos, BlockInfo> renderedBlocks) {
        for (Map.Entry<BlockPos, BlockInfo> renderEntry : renderedBlocks.entrySet()) {
            BlockPos pos = renderEntry.getKey();
            BlockInfo blockInfo = renderEntry.getValue();
            if (blockInfo.getBlockState().func_177230_c() == Blocks.field_150350_a) continue;
            this.renderedBlocks.add(pos);
            blockInfo.apply(this.world, pos);
        }
    }

    public void setRenderCallback(SceneRenderCallback callback) {
        this.renderCallback = callback;
    }

    public void setRenderFilter(Predicate<BlockPos> filter) {
        this.renderFilter = filter;
    }

    public Vector3f getSize() {
        return this.world.getSize();
    }

    public BlockPos getLastHitBlock() {
        return this.lastHitBlock;
    }

    public void render(int x, int y, int width, int height, int backgroundColor) {
        Vec2f mousePosition = WorldSceneRenderer.setupCamera(x, y, width, height, backgroundColor);
        if (this.renderCallback != null) {
            this.renderCallback.preRenderScene(this);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRendererDispatcher dispatcher = minecraft.func_175602_ab();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos pos : this.renderedBlocks) {
            if (this.renderFilter != null && !this.renderFilter.test(pos)) continue;
            IBlockState blockState = this.world.func_180495_p(pos);
            dispatcher.func_175018_a(blockState, pos, (IBlockAccess)this.world, buffer);
        }
        tessellator.func_78381_a();
        this.lastHitBlock = mousePosition != null ? this.handleMouseHit(mousePosition) : null;
        if (this.lastHitBlock != null) {
            GlStateManager.func_179090_x();
            CCRenderState renderState = CCRenderState.instance();
            renderState.startDrawing(7, DefaultVertexFormats.field_181706_f, buffer);
            ColourMultiplier multiplier = new ColourMultiplier(0);
            renderState.setPipeline(new IVertexOperation[]{new Translation((Vec3i)this.lastHitBlock), multiplier});
            BlockRenderer.BlockFace blockFace = new BlockRenderer.BlockFace();
            renderState.setModel((IVertexSource)blockFace);
            for (EnumFacing renderSide : EnumFacing.field_82609_l) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)renderSide);
                int color = (int)(255.0f * diffuse);
                multiplier.colour = RenderUtil.packColor(color, color, color, 100);
                blockFace.loadCuboidFace(Cuboid6.full, renderSide.func_176745_a());
                renderState.render();
            }
            renderState.draw();
            GlStateManager.func_179098_w();
        }
        WorldSceneRenderer.resetCamera();
    }

    private BlockPos handleMouseHit(Vec2f mousePosition) {
        GL11.glReadPixels((int)((int)mousePosition.field_189982_i), (int)((int)mousePosition.field_189983_j), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject((float)mousePosition.field_189982_i, (float)mousePosition.field_189983_j, (float)pixelDepth, (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        if (posY < -100.0f) {
            return null;
        }
        BlockPos pos = new BlockPos((double)posX, (double)posY, (double)posZ);
        if (this.world.func_175623_d(pos)) {
            for (EnumFacing offset : EnumFacing.field_82609_l) {
                BlockPos relative = pos.func_177972_a(offset);
                if (this.world.func_175623_d(relative)) continue;
                pos = relative;
                break;
            }
        }
        if (this.world.func_175623_d(pos)) {
            return null;
        }
        return pos;
    }

    public static Vec2f setupCamera(int x, int y, int width, int height, int skyColor) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        GlStateManager.func_179123_a();
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        int windowWidth = (int)((double)width / ((double)resolution.func_78326_a() * 1.0) * (double)mc.field_71443_c);
        int windowHeight = (int)((double)height / ((double)resolution.func_78328_b() * 1.0) * (double)mc.field_71440_d);
        int windowX = (int)((double)x / ((double)resolution.func_78326_a() * 1.0) * (double)mc.field_71443_c);
        int windowY = mc.field_71440_d - (int)((double)y / ((double)resolution.func_78328_b() * 1.0) * (double)mc.field_71440_d) - windowHeight;
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        Vec2f mousePosition = null;
        if (mouseX >= windowX && mouseY >= windowY && mouseX - windowX < windowWidth && mouseY - windowY < windowHeight) {
            mousePosition = new Vec2f((float)mouseX, (float)mouseY);
        }
        GlStateManager.func_179083_b((int)windowX, (int)windowY, (int)windowWidth, (int)windowHeight);
        if (skyColor >= 0) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)windowX, (int)windowY, (int)windowWidth, (int)windowHeight);
            RenderUtil.setGlClearColorFromInt(skyColor, 255);
            GlStateManager.func_179086_m((int)16640);
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GLU.gluLookAt((float)0.0f, (float)0.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        return mousePosition;
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179083_b((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    public class TrackedDummyWorld
    extends DummyWorld {
        private final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
        private final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);

        public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
            if (newState.func_177230_c() == Blocks.field_150350_a) {
                WorldSceneRenderer.this.renderedBlocks.remove(pos);
            } else {
                WorldSceneRenderer.this.renderedBlocks.add(pos);
            }
            this.minPos.setX(Math.min(this.minPos.getX(), (float)pos.func_177958_n()));
            this.minPos.setY(Math.min(this.minPos.getY(), (float)pos.func_177956_o()));
            this.minPos.setZ(Math.min(this.minPos.getZ(), (float)pos.func_177952_p()));
            this.maxPos.setX(Math.max(this.maxPos.getX(), (float)pos.func_177958_n()));
            this.maxPos.setY(Math.max(this.maxPos.getY(), (float)pos.func_177956_o()));
            this.maxPos.setZ(Math.max(this.maxPos.getZ(), (float)pos.func_177952_p()));
            return super.func_180501_a(pos, newState, flags);
        }

        public IBlockState func_180495_p(BlockPos pos) {
            if (WorldSceneRenderer.this.renderFilter != null && !WorldSceneRenderer.this.renderFilter.test(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return super.func_180495_p(pos);
        }

        public Vector3f getSize() {
            Vector3f result = new Vector3f();
            result.setX(this.maxPos.getX() - this.minPos.getX() + 1.0f);
            result.setY(this.maxPos.getY() - this.minPos.getY() + 1.0f);
            result.setZ(this.maxPos.getZ() - this.minPos.getZ() + 1.0f);
            return result;
        }

        public Vector3f getMinPos() {
            return this.minPos;
        }

        public Vector3f getMaxPos() {
            return this.maxPos;
        }
    }
}

