/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.crafttweaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.MaterialStack;
import java.util.List;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.material.MaterialRegistry")
@ZenRegister
public class CTMaterialRegistry {
    @ZenMethod
    @Nullable
    public static Material get(String name) {
        return (Material)Material.MATERIAL_REGISTRY.func_82594_a(name);
    }

    @ZenMethod
    public static List<Material> getAllMaterials() {
        return Lists.newArrayList(Material.MATERIAL_REGISTRY);
    }

    private static ImmutableList<MaterialStack> validateComponentList(@Nullable MaterialStack[] components) {
        return components == null || components.length == 0 ? ImmutableList.of() : ImmutableList.copyOf((Object[])components);
    }

    @ZenMethod
    public static FluidMaterial createFluidMaterial(int metaItemSubId, String name, int color, String iconSet, @Optional MaterialStack[] materialComponents) {
        return new FluidMaterial(metaItemSubId, name, color, MaterialIconSet.getByName(iconSet), CTMaterialRegistry.validateComponentList(materialComponents), 0L);
    }

    @ZenMethod
    public static DustMaterial createDustMaterial(int metaItemSubId, String name, int color, String iconSet, int harvestLevel, @Optional MaterialStack[] materialComponents) {
        return new DustMaterial(metaItemSubId, name, color, MaterialIconSet.getByName(iconSet), harvestLevel, CTMaterialRegistry.validateComponentList(materialComponents), 0L);
    }

    @ZenMethod
    public static GemMaterial createGemMaterial(int metaItemSubId, String name, int color, String iconSet, int harvestLevel, @Optional MaterialStack[] materialComponents, @Optional float toolSpeed, @Optional float attackDamage, @Optional int toolDurability) {
        return new GemMaterial(metaItemSubId, name, color, MaterialIconSet.getByName(iconSet), harvestLevel, CTMaterialRegistry.validateComponentList(materialComponents), 0L, null, Math.max(0.0f, toolSpeed), Math.max(0.0f, attackDamage), Math.max(0, toolDurability));
    }

    @ZenMethod
    public static IngotMaterial createIngotMaterial(int metaItemSubId, String name, int color, String iconSet, int harvestLevel, @Optional MaterialStack[] materialComponents, @Optional float toolSpeed, @Optional float attackDamage, @Optional int toolDurability, @Optional int blastFurnaceTemperature) {
        return new IngotMaterial(metaItemSubId, name, color, MaterialIconSet.getByName(iconSet), harvestLevel, CTMaterialRegistry.validateComponentList(materialComponents), 0L, null, Math.max(0.0f, toolSpeed), Math.max(0.0f, attackDamage), Math.max(0, toolDurability), blastFurnaceTemperature);
    }
}

