/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.populator;

import com.google.gson.JsonObject;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.PredicateConfigUtils;
import gregtech.api.worldgen.generator.GridEntryInfo;
import gregtech.api.worldgen.populator.VeinChunkPopulator;
import java.util.Random;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class SurfaceBlockPopulator
implements VeinChunkPopulator {
    private IBlockState blockState;
    private int minIndicatorAmount;
    private int maxIndicatorAmount;

    public SurfaceBlockPopulator() {
    }

    public SurfaceBlockPopulator(IBlockState blockState) {
        this.blockState = blockState;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        this.blockState = PredicateConfigUtils.parseBlockStateDefinition(object.getAsJsonObject("block"));
        this.minIndicatorAmount = JsonUtils.func_151208_a((JsonObject)object, (String)"min_amount", (int)0);
        this.maxIndicatorAmount = JsonUtils.func_151208_a((JsonObject)object, (String)"max_amount", (int)2);
    }

    @Override
    public void initializeForVein(OreDepositDefinition definition) {
    }

    @Override
    public void populateChunk(World world, int chunkX, int chunkZ, Random random, OreDepositDefinition definition, GridEntryInfo gridEntryInfo) {
        if (world.func_175624_G() != WorldType.field_77138_c) {
            int stonesCount = this.minIndicatorAmount + (this.minIndicatorAmount >= this.maxIndicatorAmount ? 0 : random.nextInt(this.maxIndicatorAmount - this.minIndicatorAmount));
            for (int i = 0; i < stonesCount; ++i) {
                int randomX = chunkX * 16 + random.nextInt(16);
                int randomZ = chunkZ * 16 + random.nextInt(16);
                BlockPos topBlockPos = new BlockPos(randomX, 0, randomZ);
                IBlockState blockState = world.func_180495_p(topBlockPos = world.func_175672_r(topBlockPos).func_177977_b());
                if (blockState.func_193401_d((IBlockAccess)world, topBlockPos, EnumFacing.UP) != BlockFaceShape.SOLID || !blockState.func_185914_p() || !blockState.func_185913_b()) continue;
                BlockPos surfaceRockPos = topBlockPos.func_177984_a();
                world.func_180501_a(surfaceRockPos, this.blockState, 16);
            }
        }
    }
}

