/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.common.blocks.DelayedStateBlock;
import gregtech.common.blocks.properties.PropertyMaterial;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockCompressed
extends DelayedStateBlock {
    public final PropertyMaterial variantProperty;

    public BlockCompressed(gregtech.api.unification.material.type.Material[] materials) {
        super(Material.field_151573_f);
        this.func_149663_c("compressed");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_MATERIALS);
        this.variantProperty = PropertyMaterial.create("variant", materials);
        this.initBlockState();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public String getHarvestTool(IBlockState state) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material instanceof SolidMaterial) {
            return "pickaxe";
        }
        if (material instanceof DustMaterial) {
            return "shovel";
        }
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material instanceof DustMaterial) {
            return ((DustMaterial)material).harvestLevel;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)this.variantProperty.getAllowedValues().get(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material);
    }

    public int func_176201_c(IBlockState state) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.variantProperty);
        return this.variantProperty.getAllowedValues().indexOf((Object)material);
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    public ItemStack getItem(IBlockState blockState) {
        return new ItemStack((Block)this, 1, this.func_176201_c(blockState));
    }

    public ItemStack getItem(gregtech.api.unification.material.type.Material material) {
        return this.getItem(this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b((IProperty)this.variantProperty) != Materials._NULL).forEach(blockState -> list.add((Object)this.getItem((IBlockState)blockState)));
    }

    public Material func_149688_o(IBlockState state) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material instanceof GemMaterial) {
            return Material.field_151576_e;
        }
        if (material instanceof IngotMaterial) {
            return Material.field_151573_f;
        }
        if (material instanceof DustMaterial) {
            return Material.field_151595_p;
        }
        return Material.field_151576_e;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_149688_o(state).func_151565_r();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (material instanceof GemMaterial) {
            return SoundType.field_185851_d;
        }
        if (material instanceof IngotMaterial) {
            return SoundType.field_185852_e;
        }
        if (material instanceof DustMaterial) {
            return SoundType.field_185855_h;
        }
        return SoundType.field_185851_d;
    }
}

