/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.Textures;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverConveyor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;

public class CoverRoboticArm
extends CoverConveyor {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int transferStackSize;

    public CoverRoboticArm(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide, tier, itemsPerSecond);
        this.itemFilterContainer.setMaxStackSize(this.transferMode.maxStackSize);
        this.transferStackSize = 1;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.ARM_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        switch (this.transferMode) {
            case TRANSFER_ANY: {
                return this.doTransferAny(itemHandler, myItemHandler, maxTransferAmount);
            }
            case TRANSFER_EXACT: {
                return this.doTransferExact(itemHandler, myItemHandler, maxTransferAmount);
            }
            case KEEP_EXACT: {
                return this.doKeepExact(itemHandler, myItemHandler, maxTransferAmount);
            }
        }
        return 0;
    }

    protected int doTransferExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<ItemAndMetadata, CoverConveyor.ItemInfo> sourceItemAmount = this.doCountSourceInventoryItemsByType(itemHandler, myItemHandler);
        int[] itemsTransferLimits = new int[this.itemFilterContainer.getMaxMatchSlots()];
        for (int i = 0; i < itemsTransferLimits.length; ++i) {
            int slotTransferLimit = this.itemFilterContainer.getSlotStackSize(i);
            itemsTransferLimits[i] = slotTransferLimit == -1 ? this.transferStackSize : Math.min(this.transferMode.maxStackSize, slotTransferLimit);
        }
        Iterator<ItemAndMetadata> iterator = sourceItemAmount.keySet().iterator();
        while (iterator.hasNext()) {
            ItemAndMetadata key = iterator.next();
            CoverConveyor.ItemInfo sourceInfo = sourceItemAmount.get(key);
            int itemAmount = sourceInfo.totalCount;
            int itemToMoveAmount = itemsTransferLimits[sourceInfo.filterSlot];
            if (itemAmount >= itemToMoveAmount) {
                sourceInfo.totalCount = itemToMoveAmount;
                continue;
            }
            iterator.remove();
        }
        int itemsTransferred = 0;
        for (CoverConveyor.ItemInfo itemInfo : sourceItemAmount.values()) {
            if (maxTransferAmount < itemInfo.totalCount) continue;
            boolean result = this.doTransferItemsExact(itemHandler, myItemHandler, itemInfo);
            itemsTransferred += result ? itemInfo.totalCount : 0;
            maxTransferAmount -= result ? itemInfo.totalCount : 0;
        }
        return itemsTransferred;
    }

    protected int doKeepExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        int[] currentItemAmount = this.doCountDestinationInventoryItemsByMatchIndex(itemHandler, myItemHandler);
        int[] keepItemAmount = new int[currentItemAmount.length];
        for (int i = 0; i < keepItemAmount.length; ++i) {
            int slotTransferLimit = this.itemFilterContainer.getSlotStackSize(i);
            keepItemAmount[i] = slotTransferLimit == -1 ? this.transferStackSize : slotTransferLimit;
        }
        int[] itemsToMove = CoverRoboticArm.calculateItemsToMove(currentItemAmount, keepItemAmount);
        int[] itemsMovedArray = this.doTransferItemsInternal(itemHandler, myItemHandler, maxTransferAmount, itemsToMove);
        return Arrays.stream(itemsMovedArray).sum();
    }

    private static int[] calculateItemsToMove(int[] currentItemAmount, int[] keepItemAmount) {
        int[] resultAmount = new int[currentItemAmount.length];
        for (int i = 0; i < resultAmount.length; ++i) {
            int minAmount = keepItemAmount[i];
            int currentAmount = currentItemAmount[i];
            if (minAmount <= currentAmount) continue;
            resultAmount[i] = minAmount - currentAmount;
        }
        return resultAmount;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
        this.itemFilterContainer.setMaxStackSize(transferMode.maxStackSize);
        this.transferStackSize = MathHelper.func_76125_a((int)this.transferStackSize, (int)1, (int)transferMode.maxStackSize);
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public void adjustTransferStackSize(int amount) {
        this.setTransferStackSize(this.transferStackSize + amount);
    }

    public void setTransferStackSize(int transferStackSize) {
        this.transferStackSize = MathHelper.func_76125_a((int)transferStackSize, (int)1, (int)this.transferMode.maxStackSize);
        this.coverHolder.markDirty();
    }

    public int getTransferStackSize() {
        return this.transferStackSize;
    }

    @Override
    protected String getUITitle() {
        return "cover.robotic_arm.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        WidgetGroup filterGroup = new WidgetGroup();
        filterGroup.addWidget(new CycleButtonWidget(91, 45, 75, 20, GTUtility.mapToString(TransferMode.values(), it -> it.localeName), () -> this.transferMode.ordinal(), newMode -> this.setTransferMode(TransferMode.values()[newMode])).setTooltipHoverString("cover.robotic_arm.transfer_mode.description"));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(() -> this.transferMode.maxStackSize > 1 && this.itemFilterContainer.getSlotStackSize(0) == -1);
        stackSizeGroup.addWidget(new ClickButtonWidget(91, 70, 20, 20, "-1", data -> this.adjustTransferStackSize(data.isShiftClick ? -10 : -1)));
        stackSizeGroup.addWidget(new ClickButtonWidget(146, 70, 20, 20, "+1", data -> this.adjustTransferStackSize(data.isShiftClick ? 10 : 1)));
        stackSizeGroup.addWidget(new ImageWidget(111, 70, 35, 20, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new SimpleTextWidget(128, 80, "", 0xFFFFFF, () -> Integer.toString(this.transferStackSize)));
        return super.buildUI(builder.widget(filterGroup).widget(stackSizeGroup), player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
    }

    public static enum TransferMode {
        TRANSFER_ANY("cover.robotic_arm.transfer_mode.transfer_any", 1),
        TRANSFER_EXACT("cover.robotic_arm.transfer_mode.transfer_exact", 64),
        KEEP_EXACT("cover.robotic_arm.transfer_mode.keep_exact", 1024);

        public final String localeName;
        public final int maxStackSize;

        private TransferMode(String localeName, int maxStackSize) {
            this.localeName = localeName;
            this.maxStackSize = maxStackSize;
        }
    }
}

