/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.common.covers.filter.AbstractItemFilter;
import gregtech.common.covers.filter.ISlottedItemFilter;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleItemFilter
extends AbstractItemFilter
implements ISlottedItemFilter {
    private static final int MAX_MATCH_SLOTS = 9;
    protected ItemStackHandler itemFilterSlots = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return SimpleItemFilter.this.maxStackSize;
        }
    };
    protected boolean ignoreDamage = true;
    protected boolean ignoreNBT = true;
    protected int maxStackSize = 1;

    protected void setIgnoreDamage(boolean ignoreDamage) {
        this.ignoreDamage = ignoreDamage;
        this.markDirty();
    }

    protected void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.markDirty();
    }

    public ItemStackHandler getItemFilterSlots() {
        return this.itemFilterSlots;
    }

    public boolean isIgnoreDamage() {
        return this.ignoreDamage;
    }

    public boolean isIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public int getMaxMatchSlots() {
        return 9;
    }

    @Override
    public int matchItemStack(ItemStack itemStack) {
        return SimpleItemFilter.itemFilterMatch((IItemHandler)this.getItemFilterSlots(), this.isIgnoreDamage(), this.isIgnoreNBT(), itemStack);
    }

    @Override
    public boolean testItemStack(ItemStack itemStack) {
        return this.matchItemStack(itemStack) != -1;
    }

    @Override
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public int getSlotStackSize(int slotIndex) {
        return this.itemFilterSlots.getStackInSlot(slotIndex).func_190916_E();
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 36;
    }

    @Override
    public void initUI(int y, Consumer<Widget> widgetGroup) {
        for (int i = 0; i < 9; ++i) {
            widgetGroup.accept(new PhantomSlotWidget((IItemHandlerModifiable)this.itemFilterSlots, i, 10 + 18 * (i % 3), y + 18 * (i / 3)).setBackgroundTexture(GuiTextures.SLOT));
        }
        widgetGroup.accept(new ToggleButtonWidget(74, y, 20, 20, GuiTextures.BUTTON_FILTER_DAMAGE, () -> this.ignoreDamage, this::setIgnoreDamage).setTooltipText("cover.item_filter.ignore_damage"));
        widgetGroup.accept(new ToggleButtonWidget(99, y, 20, 20, GuiTextures.BUTTON_FILTER_NBT, () -> this.ignoreNBT, this::setIgnoreNBT).setTooltipText("cover.item_filter.ignore_nbt"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("ItemFilter", (NBTBase)this.itemFilterSlots.serializeNBT());
        tagCompound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        tagCompound.func_74757_a("IgnoreNBT", this.ignoreNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.itemFilterSlots.deserializeNBT(tagCompound.func_74775_l("ItemFilter"));
        this.ignoreDamage = tagCompound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = tagCompound.func_74767_n("IgnoreNBT");
    }

    public static int itemFilterMatch(IItemHandler filterSlots, boolean ignoreDamage, boolean ignoreNBTData, ItemStack itemStack) {
        for (int i = 0; i < filterSlots.getSlots(); ++i) {
            ItemStack filterStack = filterSlots.getStackInSlot(i);
            if (filterStack.func_190926_b() || !SimpleItemFilter.areItemsEqual(ignoreDamage, ignoreNBTData, filterStack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean areItemsEqual(boolean ignoreDamage, boolean ignoreNBTData, ItemStack filterStack, ItemStack itemStack) {
        if (ignoreDamage ? !filterStack.func_185136_b(itemStack) : !filterStack.func_77969_a(itemStack)) {
            return false;
        }
        return ignoreNBTData || ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)itemStack);
    }
}

