/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.common.covers.filter.AbstractItemFilter;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.ISlottedItemFilter;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class WidgetGroupItemFilter
extends AbstractWidgetGroup {
    private final int yPosition;
    private Supplier<AbstractItemFilter> itemFilterSupplier;
    private AbstractItemFilter itemFilter;
    private int maxStackSize = 1;

    public WidgetGroupItemFilter(int yPosition, Supplier<AbstractItemFilter> itemFilterSupplier) {
        this.yPosition = yPosition;
        this.itemFilterSupplier = itemFilterSupplier;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        AbstractItemFilter newItemFilter = this.itemFilterSupplier.get();
        if (this.itemFilter != newItemFilter) {
            this.clearAllWidgets();
            this.itemFilter = newItemFilter;
            if (this.itemFilter != null) {
                this.itemFilter.initUI(this.yPosition, this::addWidget);
            }
            this.writeUpdateInfo(2, buffer -> {
                if (this.itemFilter != null) {
                    buffer.writeBoolean(true);
                    int filterId = FilterTypeRegistry.getIdForItemFilter(this.itemFilter);
                    buffer.func_150787_b(filterId);
                } else {
                    buffer.writeBoolean(false);
                }
            });
        }
        int newMaxStackSize = 1;
        if (this.itemFilter instanceof ISlottedItemFilter) {
            newMaxStackSize = ((ISlottedItemFilter)((Object)this.itemFilter)).getMaxStackSize();
        }
        if (this.maxStackSize != newMaxStackSize) {
            this.maxStackSize = newMaxStackSize;
            this.writeUpdateInfo(3, buffer -> buffer.func_150787_b(this.maxStackSize));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.clearAllWidgets();
            if (buffer.readBoolean()) {
                int filterId = buffer.func_150792_a();
                this.itemFilter = FilterTypeRegistry.createItemFilterById(filterId);
                this.itemFilter.initUI(this.yPosition, this::addWidget);
                if (this.itemFilter instanceof ISlottedItemFilter) {
                    ((ISlottedItemFilter)((Object)this.itemFilter)).setMaxStackSize(this.maxStackSize);
                }
            }
        } else if (id == 3) {
            this.maxStackSize = buffer.func_150792_a();
            if (this.itemFilter instanceof ISlottedItemFilter) {
                ((ISlottedItemFilter)((Object)this.itemFilter)).setMaxStackSize(this.maxStackSize);
            }
        }
    }
}

