/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemMaxStackSizeProvider;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.common.items.behaviors.AbstractMaterialPartBehavior;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class TurbineRotorBehavior
extends AbstractMaterialPartBehavior
implements IItemMaxStackSizeProvider {
    private static final int TOOL_DURABILITY_MULTIPLIER = 100;

    public static TurbineRotorBehavior getInstanceFor(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof MetaItem)) {
            return null;
        }
        MetaItem metaItem = (MetaItem)itemStack.func_77973_b();
        Object valueItem = metaItem.getItem(itemStack);
        if (valueItem == null) {
            return null;
        }
        IItemDurabilityManager durabilityManager = ((MetaItem.MetaValueItem)valueItem).getDurabilityManager();
        if (!(durabilityManager instanceof TurbineRotorBehavior)) {
            return null;
        }
        return (TurbineRotorBehavior)durabilityManager;
    }

    @Override
    public int getPartMaxDurability(ItemStack itemStack) {
        IngotMaterial material = this.getPartMaterial(itemStack);
        return material.toolDurability * 100;
    }

    public double getRotorEfficiency(ItemStack itemStack) {
        IngotMaterial primaryMaterial = this.getPartMaterial(itemStack);
        return primaryMaterial == null ? 0.1 : Math.min((double)primaryMaterial.toolSpeed / 14.0, 1.0);
    }

    public void applyRotorDamage(ItemStack itemStack, int damageApplied) {
        int rotorDurability = this.getPartMaxDurability(itemStack);
        int resultDamage = this.getPartDamage(itemStack) + damageApplied;
        if (resultDamage >= rotorDurability) {
            itemStack.func_190918_g(1);
        } else {
            this.setPartDamage(itemStack, resultDamage);
        }
    }

    @Override
    public int getMaxStackSize(ItemStack itemStack, int defaultValue) {
        return 1;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> lines) {
        super.addInformation(stack, lines);
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.rotor.efficiency", (Object[])new Object[]{(int)(this.getRotorEfficiency(stack) * 100.0)}));
    }
}

