/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.potions;

import gregtech.common.items.potions.PotionFluids;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.ArrayUtils;

public class GlassBottleFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack itemStack;
    private Collection<ICapabilityProvider> rawCapabilityProviders;
    private IFluidHandlerItem nextHandlerInChain;

    public GlassBottleFluidHandler(ItemStack itemStack, Collection<ICapabilityProvider> rawCapabilityProviders) {
        this.itemStack = itemStack;
        this.rawCapabilityProviders = rawCapabilityProviders;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.itemStack;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidHandlerItem nextInChain = this.getNextInChain();
        Object[] properties = nextInChain == null ? new IFluidTankProperties[]{} : nextInChain.getTankProperties();
        FluidTankProperties ownProperties = new FluidTankProperties(null, 100, true, false);
        return (IFluidTankProperties[])ArrayUtils.add((Object[])properties, (Object)ownProperties);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        int myOwnResult = this.fillImpl(resource, doFill);
        if (myOwnResult == 0) {
            IFluidHandlerItem nextInChain = this.getNextInChain();
            return nextInChain == null ? 0 : nextInChain.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        IFluidHandlerItem nextInChain = this.getNextInChain();
        return nextInChain == null ? null : nextInChain.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        IFluidHandlerItem nextInChain = this.getNextInChain();
        return nextInChain == null ? null : nextInChain.drain(maxDrain, doDrain);
    }

    private int fillImpl(FluidStack resource, boolean doFill) {
        PotionType potionType = PotionFluids.getPotionForFluid(resource.getFluid());
        if (potionType != null && potionType != PotionTypes.field_185229_a && resource.amount >= 100) {
            if (doFill) {
                this.itemStack = new ItemStack((Item)Items.field_151068_bn);
                PotionUtils.func_185188_a((ItemStack)this.itemStack, (PotionType)potionType);
            }
            return 100;
        }
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    private IFluidHandlerItem getNextInChain() {
        if (this.rawCapabilityProviders != null) {
            boolean foundMyself = false;
            for (ICapabilityProvider provider : this.rawCapabilityProviders) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)provider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandlerItem == null) continue;
                if (fluidHandlerItem == this) {
                    foundMyself = true;
                    continue;
                }
                if (!foundMyself) continue;
                this.nextHandlerInChain = fluidHandlerItem;
                break;
            }
            this.rawCapabilityProviders = null;
        }
        return this.nextHandlerInChain;
    }
}

