/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.Materials;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class MetaTileEntityAirCollector
extends TieredMetaTileEntity {
    public MetaTileEntityAirCollector(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityAirCollector(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(32000)});
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            long energyToConsume = GTValues.V[this.getTier()];
            if (this.checkOpenSides() && this.getTimer() % 20L == 0L && this.energyContainer.getEnergyStored() >= energyToConsume) {
                int fluidAmount = 500 * (1 << this.getTier());
                this.exportFluids.fill(Materials.Air.getFluid(fluidAmount), true);
                this.energyContainer.removeEnergy(energyToConsume);
            }
            if (this.getTimer() % 5L == 0L) {
                this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            }
        }
    }

    private boolean checkOpenSides() {
        EnumFacing frontFacing = this.getFrontFacing();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side == frontFacing || !this.getWorld().func_175623_d(this.getPos().func_177972_a(side))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        EnumFacing frontFacing = this.getFrontFacing();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_176740_k().func_176722_c()) {
                Textures.AIR_VENT_OVERLAY.renderSided(side, renderState, translation, pipeline);
                continue;
            }
            Textures.FILTER_OVERLAY.renderSided(side, renderState, translation, pipeline);
        }
        Textures.PIPE_OUT_OVERLAY.renderSided(frontFacing, renderState, translation, pipeline);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }
}

