/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.blocks.surfacerock.BlockSurfaceRockFlooded;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class StoneRenderer
implements ICCBlockRenderer {
    private static final StoneRenderer INSTANCE = new StoneRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private BlockFluidRenderer waterRenderer;
    private BlockColors blockColors;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_stone");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
    }

    private void lazyInitializeRenderers() {
        if (this.waterRenderer == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            BlockRendererDispatcher dispatcher = minecraft.func_175602_ab();
            this.blockColors = minecraft.func_184125_al();
            this.waterRenderer = (BlockFluidRenderer)ObfuscationReflectionHelper.getPrivateValue(BlockRendererDispatcher.class, (Object)dispatcher, (int)3);
        }
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        Cuboid6 baseBox = BlockSurfaceRock.getShapeFromBlockPos(pos);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        this.lazyInitializeRenderers();
        if (state.func_177230_c() instanceof BlockSurfaceRockFlooded && MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT) {
            this.waterRenderer.func_178270_a(world, state, pos, buffer);
            return true;
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        Matrix4 translation = new Matrix4();
        translation.translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        IVertexOperation[] operations = new IVertexOperation[]{new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.blockColors.func_186724_a(state, world, pos, 1)))};
        if (world != null) {
            renderState.setBrightness(world, pos);
        }
        TextureAtlasSprite stoneSprite = TextureUtils.getBlockTexture((String)"stone");
        Cuboid6 baseBox = BlockSurfaceRock.getShapeFromBlockPos(pos);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, operations, renderSide, baseBox, stoneSprite);
        }
        return true;
    }

    public void renderBrightness(IBlockState state, float brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.renderBlock(null, BlockPos.field_177992_a, state, tessellator.func_178180_c());
        tessellator.func_78381_a();
    }

    public void registerTextures(TextureMap map) {
    }
}

