/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.vec.Vector3;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import gregtech.common.items.behaviors.CrowbarBehaviour;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class WrenchOverlayRenderer {
    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        RayTraceResult target = event.getTarget();
        if (target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        IBlockState blockState = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (tileEntity != null && WrenchOverlayRenderer.shouldDrawOverlayForItem(heldItem, tileEntity) && WrenchOverlayRenderer.useGridForRayTraceResult(target)) {
            EnumFacing facing = target.field_178784_b;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            if (world.func_175723_af().func_177746_a(pos)) {
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                AxisAlignedBB box = blockState.func_185918_c(world, pos).func_186662_g(0.002).func_72317_d(-d3, -d4, -d5);
                RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                WrenchOverlayRenderer.drawOverlayLines(facing, box);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }

    public static boolean useGridForRayTraceResult(RayTraceResult result) {
        if (result instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult traceResult = (CuboidRayTraceResult)result;
            if (traceResult.cuboid6.data == null) {
                return true;
            }
            if (traceResult.cuboid6.data instanceof ICoverable.PrimaryBoxData) {
                ICoverable.PrimaryBoxData primaryBoxData = (ICoverable.PrimaryBoxData)traceResult.cuboid6.data;
                return primaryBoxData.usePlacementGrid;
            }
            return false;
        }
        return true;
    }

    public static boolean shouldDrawOverlayForItem(ItemStack itemStack, TileEntity tileEntity) {
        if (tileEntity instanceof MetaTileEntityHolder && itemStack.hasCapability(GregtechCapabilities.CAPABILITY_WRENCH, null)) {
            return true;
        }
        if (tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_COVERABLE, null)) {
            MetaItem metaItem;
            Object valueItem;
            if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_SCREWDRIVER, null)) {
                return true;
            }
            if (itemStack.func_77973_b() instanceof MetaItem && (valueItem = (metaItem = (MetaItem)itemStack.func_77973_b()).getItem(itemStack)) != null) {
                List<IItemBehaviour> behaviourList = ((MetaItem.MetaValueItem)valueItem).getBehaviours();
                return behaviourList.stream().anyMatch(it -> it instanceof CoverPlaceBehavior || it instanceof CrowbarBehaviour);
            }
        }
        return false;
    }

    private static void drawOverlayLines(EnumFacing facing, AxisAlignedBB box) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3 topRight = new Vector3(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        Vector3 bottomRight = new Vector3(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        Vector3 bottomLeft = new Vector3(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        Vector3 topLeft = new Vector3(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        Vector3 shift = new Vector3(0.25, 0.0, 0.0);
        Vector3 shiftVert = new Vector3(0.0, 0.25, 0.0);
        Vector3 cubeCenter = new Vector3(box.func_189972_c());
        topRight.subtract(cubeCenter);
        bottomRight.subtract(cubeCenter);
        bottomLeft.subtract(cubeCenter);
        topLeft.subtract(cubeCenter);
        switch (facing) {
            case WEST: {
                topRight.rotate(1.5707963267948966, Vector3.down);
                bottomRight.rotate(1.5707963267948966, Vector3.down);
                bottomLeft.rotate(1.5707963267948966, Vector3.down);
                topLeft.rotate(1.5707963267948966, Vector3.down);
                shift.rotate(1.5707963267948966, Vector3.down);
                shiftVert.rotate(1.5707963267948966, Vector3.down);
                break;
            }
            case EAST: {
                topRight.rotate(-1.5707963267948966, Vector3.down);
                bottomRight.rotate(-1.5707963267948966, Vector3.down);
                bottomLeft.rotate(-1.5707963267948966, Vector3.down);
                topLeft.rotate(-1.5707963267948966, Vector3.down);
                shift.rotate(-1.5707963267948966, Vector3.down);
                shiftVert.rotate(-1.5707963267948966, Vector3.down);
                break;
            }
            case NORTH: {
                topRight.rotate(Math.PI, Vector3.down);
                bottomRight.rotate(Math.PI, Vector3.down);
                bottomLeft.rotate(Math.PI, Vector3.down);
                topLeft.rotate(Math.PI, Vector3.down);
                shift.rotate(Math.PI, Vector3.down);
                shiftVert.rotate(Math.PI, Vector3.down);
                break;
            }
            case UP: {
                Vector3 side = new Vector3(1.0, 0.0, 0.0);
                topRight.rotate(-1.5707963267948966, side);
                bottomRight.rotate(-1.5707963267948966, side);
                bottomLeft.rotate(-1.5707963267948966, side);
                topLeft.rotate(-1.5707963267948966, side);
                shift.rotate(-1.5707963267948966, side);
                shiftVert.rotate(-1.5707963267948966, side);
                break;
            }
            case DOWN: {
                Vector3 side = new Vector3(1.0, 0.0, 0.0);
                topRight.rotate(1.5707963267948966, side);
                bottomRight.rotate(1.5707963267948966, side);
                bottomLeft.rotate(1.5707963267948966, side);
                topLeft.rotate(1.5707963267948966, side);
                shift.rotate(1.5707963267948966, side);
                shiftVert.rotate(1.5707963267948966, side);
                break;
            }
        }
        topRight.add(cubeCenter);
        bottomRight.add(cubeCenter);
        bottomLeft.add(cubeCenter);
        topLeft.add(cubeCenter);
        WrenchOverlayRenderer.startLine(buffer, topRight.copy().add(shift.copy().negate()));
        WrenchOverlayRenderer.endLine(buffer, bottomRight.copy().add(shift.copy().negate()));
        WrenchOverlayRenderer.startLine(buffer, bottomLeft.copy().add(shift));
        WrenchOverlayRenderer.endLine(buffer, topLeft.copy().add(shift));
        WrenchOverlayRenderer.startLine(buffer, topLeft.copy().add(shiftVert.copy().negate()));
        WrenchOverlayRenderer.endLine(buffer, topRight.copy().add(shiftVert.copy().negate()));
        WrenchOverlayRenderer.startLine(buffer, bottomLeft.copy().add(shiftVert));
        WrenchOverlayRenderer.endLine(buffer, bottomRight.copy().add(shiftVert));
        tessellator.func_78381_a();
    }

    private static void startLine(BufferBuilder buffer, Vector3 vec) {
        buffer.func_181662_b(vec.x, vec.y, vec.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
    }

    private static void endLine(BufferBuilder buffer, Vector3 vec) {
        buffer.func_181662_b(vec.x, vec.y, vec.z).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
    }
}

