/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.recipes.RecipeMaps;
import gregtech.common.tools.ToolBase;
import gregtech.common.tools.ToolUtility;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ToolHardHammer
extends ToolBase {
    @Override
    public boolean canApplyEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151035_b);
    }

    @Override
    public float getNormalDamageBonus(EntityLivingBase entity, ItemStack stack, EntityLivingBase attacker) {
        String name = entity.getClass().getName();
        return (name = name.substring(name.lastIndexOf(46) + 1)).toLowerCase().contains("golem") ? 2.0f : 1.0f;
    }

    @Override
    public int getToolDamagePerBlockBreak(ItemStack stack) {
        return 1;
    }

    @Override
    public int getToolDamagePerDropConversion(ItemStack stack) {
        return 0;
    }

    @Override
    public int getToolDamagePerContainerCraft(ItemStack stack) {
        return 2;
    }

    @Override
    public float getBaseDamage(ItemStack stack) {
        return 4.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier(ItemStack stack) {
        return 2.0f;
    }

    @Override
    public float getDigSpeedMultiplier(ItemStack stack) {
        return 1.5f;
    }

    @Override
    public float getAttackSpeed(ItemStack stack) {
        return -3.0f;
    }

    @Override
    public boolean canMineBlock(IBlockState block, ItemStack stack) {
        String tool = block.func_177230_c().getHarvestTool(block);
        ItemStack itemStack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block));
        return tool != null && (tool.equals("hammer") || tool.equals("pickaxe")) || block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151592_s || block.func_185904_a() == Material.field_151588_w || block.func_185904_a() == Material.field_151598_x || RecipeMaps.FORGE_HAMMER_RECIPES.findRecipe(Long.MAX_VALUE, Collections.singletonList(itemStack), Collections.emptyList(), 0) != null;
    }

    @Override
    public void convertBlockDrops(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, List<ItemStack> dropList, ItemStack toolStack) {
        ToolUtility.applyHammerDrops(world.field_73012_v, blockState, dropList, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)toolStack));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> lines, boolean isAdvanced) {
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.hammer.extra_drop", (Object[])new Object[0]));
    }
}

