/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.TaskScheduler;
import gregtech.common.tools.TreeChopTask;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ToolUtility {
    public static EnumFacing getSideHit(World world, BlockPos blockPos, EntityPlayer harvester) {
        RayTraceResult result = RayTracer.retraceBlock((World)world, (EntityPlayer)harvester, (BlockPos)blockPos);
        return result == null ? harvester.func_174811_aO() : result.field_178784_b;
    }

    public static boolean applyTimberAxe(ItemStack itemStack, World world, BlockPos blockPos, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(blockPos);
        if (TreeChopTask.isLogBlock(blockState) == 1) {
            if (!world.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                TreeChopTask treeChopTask = new TreeChopTask(blockPos, world, playerMP, itemStack);
                TaskScheduler.scheduleTask(world, treeChopTask);
            }
            return true;
        }
        return false;
    }

    public static boolean applyShearBehavior(ItemStack itemStack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemStack, (IBlockAccess)player.field_70170_p, pos)) {
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack);
            List drops = target.onSheared(itemStack, (IBlockAccess)player.field_70170_p, pos, fortuneLevel);
            ToolUtility.dropListOfItems(player.field_70170_p, pos, drops);
            player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return true;
        }
        return false;
    }

    public static boolean applyHarvestBehavior(BlockPos pos, EntityPlayer player) {
        BlockCrops blockCrops;
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockCrops && (blockCrops = (BlockCrops)block).func_185525_y(blockState)) {
            List drops = blockCrops.getDrops((IBlockAccess)player.field_70170_p, pos, blockState, 0);
            ToolUtility.dropListOfItems(player.field_70170_p, pos, drops);
            player.field_70170_p.func_175656_a(pos, blockCrops.func_185528_e(0));
            return true;
        }
        return false;
    }

    private static void dropListOfItems(World world, BlockPos pos, List<ItemStack> drops) {
        Random rand = new Random();
        for (ItemStack stack : drops) {
            float f = 0.7f;
            double offX = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offY = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offZ = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + offX, (double)pos.func_177956_o() + offY, (double)pos.func_177952_p() + offZ, stack);
            entityItem.func_174869_p();
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static void applyHammerDrops(Random random, IBlockState blockState, List<ItemStack> drops, int fortuneLevel) {
        ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
        Recipe recipe = RecipeMaps.FORGE_HAMMER_RECIPES.findRecipe(Long.MAX_VALUE, Collections.singletonList(itemStack), Collections.emptyList(), 0);
        if (recipe != null && !recipe.getOutputs().isEmpty()) {
            drops.clear();
            for (ItemStack outputStack : recipe.getResultItemOutputs(random, 1)) {
                if (OreDictUnifier.getPrefix(outputStack = outputStack.func_77946_l()) == OrePrefix.crushed) {
                    int growAmount = Math.round((float)outputStack.func_190916_E() * random.nextFloat());
                    if (fortuneLevel > 0) {
                        int i = Math.max(0, random.nextInt(fortuneLevel + 2) - 1);
                        growAmount += outputStack.func_190916_E() * i;
                    }
                    outputStack.func_190917_f(growAmount);
                }
                drops.add(outputStack);
            }
        }
    }
}

