/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.Main;
import com.gmail.trentech.pjw.commands.CommandCreate;
import com.gmail.trentech.pjw.io.SpongeData;
import com.gmail.trentech.pjw.io.WorldData;
import com.gmail.trentech.pjw.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandLoad
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world load").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (arguments.equalsIgnoreCase("load")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (arguments.equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        Optional optionalWorld = Sponge.getServer().getWorldProperties(arguments);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, arguments, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalWorld.get();
        if (Sponge.getServer().getWorld(world.getUniqueId()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, world.getWorldName(), " is already loaded"}), false);
        }
        WorldData worldData = new WorldData(world.getWorldName());
        if (!worldData.exists()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, world.getWorldName(), " does not exist"}), false);
        }
        SpongeData spongeData = new SpongeData(world.getWorldName());
        if (!spongeData.exists()) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Foriegn world detected"}));
            source.sendMessage(Text.builder().color(TextColors.YELLOW).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for more information "))).onClick((ClickAction)TextActions.runCommand((String)"/pjw:world import")).append(new Text[]{Text.of((String)" /world import")}).build());
            return CommandResult.success();
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Preparing spawn area. This may take a minute."}));
        Task.builder().delayTicks(20L).execute(c -> {
            Optional load = Sponge.getServer().loadWorld(world);
            if (!load.isPresent()) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not load ", world.getWorldName()}));
                return;
            }
            if (CommandCreate.worlds.contains(world.getWorldName())) {
                Utils.createPlatform((Location<World>)((World)load.get()).getSpawnLocation().getRelative(Direction.DOWN));
                CommandCreate.worlds.remove(world.getWorldName());
            }
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, world.getWorldName(), " loaded successfully"}));
        }).submit((Object)Main.getPlugin());
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("load")) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(arguments)) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(arguments.toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

