/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.Main;
import com.gmail.trentech.pjw.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandRegen
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world regen").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        WorldProperties newProperties;
        String worldName;
        if (arguments.equalsIgnoreCase("regen")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.getHelp().execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties properties = (WorldProperties)optionalProperties.get();
        if (Sponge.getServer().getWorld(properties.getWorldName()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, properties.getWorldName(), " must be unloaded before you can regenerate"}), false);
        }
        WorldArchetype.Builder builder = WorldArchetype.builder().from(properties);
        try {
            String bool = args[1];
            if (!bool.equalsIgnoreCase("true") && !bool.equalsIgnoreCase("false")) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, bool, " is not a valid Boolean"}));
                throw new CommandException(this.getHelp().getUsageText());
            }
            try {
                String seed = args[2];
                try {
                    Long s = Long.parseLong(seed);
                    builder.seed(s.longValue());
                }
                catch (Exception e) {
                    builder.seed((long)seed.hashCode());
                }
            }
            catch (Exception e) {
                builder.randomSeed();
            }
        }
        catch (Exception seed) {
            // empty catch block
        }
        try {
            CompletableFuture delete = Sponge.getServer().deleteWorld(properties);
            while (!delete.isDone()) {
            }
            if (!((Boolean)delete.get()).booleanValue()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Could not delete ", properties.getWorldName()}), false);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Regenerating world.."}));
        WorldArchetype settings = builder.enabled(true).loadsOnStartup(true).build(properties.getWorldName() + "_" + (ThreadLocalRandom.current().nextInt(100) + 1), properties.getWorldName());
        try {
            newProperties = Sponge.getServer().createWorldProperties(properties.getWorldName(), settings);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Something went wrong. Check server log for details"}), false);
        }
        Task.builder().delayTicks(20L).execute(c -> {
            Optional load = Sponge.getServer().loadWorld(newProperties);
            if (!load.isPresent()) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not load ", properties.getWorldName()}));
                return;
            }
            Utils.createPlatform((Location<World>)((World)load.get()).getSpawnLocation().getRelative(Direction.DOWN));
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, properties.getWorldName(), " regenerated successfully"}));
        }).submit((Object)Main.getPlugin());
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("regen")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    list.add("true");
                    list.add("false");
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
            return list;
        }
        if (args.length >= 2) {
            if ("true".equalsIgnoreCase(args[1].toLowerCase()) || "false".equalsIgnoreCase(args[1].toLowerCase())) {
                return list;
            }
            if ("true".startsWith(args[1].toLowerCase())) {
                list.add("true");
            }
            if ("false".startsWith(args[1].toLowerCase())) {
                list.add("false");
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

