/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.obnoxint.xnbt.BaseTag;
import net.obnoxint.xnbt.NBTInputStream;
import net.obnoxint.xnbt.NBTOutputStream;
import net.obnoxint.xnbt.Tag;
import net.obnoxint.xnbt.XNBT;
import net.obnoxint.xnbt.types.ByteArrayTag;
import net.obnoxint.xnbt.types.ByteTag;
import net.obnoxint.xnbt.types.CompoundTag;
import net.obnoxint.xnbt.types.DoubleTag;
import net.obnoxint.xnbt.types.FloatTag;
import net.obnoxint.xnbt.types.IntegerArrayTag;
import net.obnoxint.xnbt.types.IntegerTag;
import net.obnoxint.xnbt.types.ListTag;
import net.obnoxint.xnbt.types.LongTag;
import net.obnoxint.xnbt.types.NBTTag;
import net.obnoxint.xnbt.types.ShortTag;
import net.obnoxint.xnbt.types.StringTag;
import net.obnoxint.xnbt.types.TagHeader;
import net.obnoxint.xnbt.types.XNBTTag;

abstract class BaseTagIOHandler
implements XNBT.TagIOHandler {
    private static final XNBT.TagIOHandler[] handlers = new BaseTagIOHandler[NBTTag.BaseType.values().length];
    static final XNBT.TagIOHandler xnbtHandler = new XNBT.TagIOHandler(){

        @Override
        public XNBTTag build(byte type, String name, Object payload) {
            return new XNBTTag(payload);
        }

        @Override
        public Object read(NBTInputStream in) throws IOException {
            Object r;
            Class<?> docClass;
            CompoundTag root = (CompoundTag)in.readTag();
            CompoundTag settings = (CompoundTag)root.get(".settings");
            CompoundTag document = (CompoundTag)root.get(((StringTag)settings.get("name")).getPayload());
            try {
                docClass = Class.forName(((StringTag)settings.get("class")).getPayload());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("class not found: " + ((StringTag)settings.get("class")).getPayload(), e);
            }
            try {
                r = docClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IOException("failed to instantiate " + docClass.getName(), e);
            }
            HashMap<String, Field> fields = new HashMap<String, Field>();
            for (Field f : r.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(Tag.class)) continue;
                fields.put(f.getAnnotation(Tag.class).name().isEmpty() ? f.getName() : f.getAnnotation(Tag.class).name(), f);
            }
            for (String fieldName : document.keySet()) {
                if (!fields.containsKey(fieldName)) continue;
                Field field = (Field)fields.get(fieldName);
                field.setAccessible(true);
                try {
                    field.set(r, this.tagToObject(document.get(fieldName), field.getClass()));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IOException(e);
                }
                field.setAccessible(false);
            }
            return r;
        }

        @Override
        public void write(Object payload, NBTOutputStream out) throws IOException {
            String docName = null;
            if (payload.getClass().isAnnotationPresent(Tag.class)) {
                docName = payload.getClass().getAnnotation(Tag.class).name();
            }
            if (docName == null || docName.isEmpty()) {
                docName = payload.getClass().getSimpleName();
            }
            CompoundTag root = new CompoundTag("XNBTDocument", null);
            CompoundTag settings = new CompoundTag(".settings", null);
            CompoundTag document = new CompoundTag(docName, null);
            settings.put(new IntegerTag("version", 0));
            settings.put(new StringTag("editor", "XNBT"));
            settings.put(new StringTag("class", payload.getClass().getName()));
            settings.put(new StringTag("name", docName));
            for (Field field : payload.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Tag.class)) continue;
                byte type = field.getAnnotation(Tag.class).type();
                String name = field.getAnnotation(Tag.class).name();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                field.setAccessible(true);
                try {
                    document.put(this.objectToTag(type, name, field.get(payload)));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IOException(e);
                }
                field.setAccessible(false);
            }
            root.put(settings);
            root.put(document);
            out.writeTag(root);
        }

        private XNBT.TagBuilder getBuilderForPayloadClass(Class<? extends Object> clazz) throws IOException {
            for (XNBT.TagBuilder tb : XNBT.getBuilders().values()) {
                try {
                    if (!tb.getClass().getDeclaredMethod("build", Byte.TYPE, String.class, Object.class).getReturnType().getDeclaredMethod("getPayload", new Class[0]).getReturnType().equals(clazz)) continue;
                    return tb;
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new IOException(e);
                }
            }
            return null;
        }

        private boolean isAnnotated(Class<? extends Object> c) {
            if (c.isAnnotationPresent(Tag.class)) {
                return true;
            }
            for (Field f : c.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Tag.class)) continue;
                return true;
            }
            return false;
        }

        private NBTTag objectToTag(byte type, String name, Object payload) throws IOException {
            XNBT.TagBuilder builder = null;
            Class<Object> pc = payload.getClass();
            if (type == 0) {
                if (pc.isAssignableFrom(NBTTag.class)) {
                    NBTTag tag = (NBTTag)payload;
                    return XNBT.getBuilder(tag.getHeader().getType()).build(tag.getHeader().getType(), name, tag.getPayload());
                }
                if (pc.isAssignableFrom(List.class)) {
                    List list = (List)payload;
                    ListTag lTag = new ListTag(name);
                    for (Object o : list) {
                        lTag.add(this.objectToTag((byte)0, null, o));
                    }
                    return lTag;
                }
                if (pc.isAssignableFrom(Map.class)) {
                    Map map = (Map)payload;
                    CompoundTag cTag = new CompoundTag(name);
                    for (String s : map.keySet()) {
                        cTag.put(this.objectToTag((byte)0, s, map.get(s)));
                    }
                    return cTag;
                }
                if (this.isAnnotated(pc)) {
                    return new XNBTTag(payload);
                }
                builder = this.getBuilderForPayloadClass(pc);
            } else {
                builder = XNBT.getBuilder(type);
            }
            if (builder == null) {
                throw new IOException("no builder found for " + payload.getClass().getName());
            }
            return builder.build(type, name, payload);
        }

        private Object tagToObject(NBTTag tag, Class<? extends Object> clazz) throws IOException {
            if (clazz.isAssignableFrom(NBTTag.class)) {
                return tag;
            }
            if (clazz.isAssignableFrom(List.class) && tag.getHeader().getType() == NBTTag.BaseType.LIST.Id()) {
                ArrayList<Object> list = new ArrayList<Object>();
                ListTag lTag = (ListTag)tag;
                for (int i = 0; i < lTag.size(); ++i) {
                    NBTTag e = lTag.get(i);
                    list.add(this.tagToObject(e, e.getPayload().getClass()));
                }
                return list;
            }
            if (clazz.isAssignableFrom(Map.class) && tag.getHeader().getType() == NBTTag.BaseType.COMPOUND.Id()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                CompoundTag cTag = (CompoundTag)tag;
                for (String k : cTag.keySet()) {
                    NBTTag v = cTag.get(k);
                    map.put(k, this.tagToObject(v, v.getPayload().getClass()));
                }
                return map;
            }
            return tag.getPayload();
        }
    };

    static XNBT.TagIOHandler[] getHandlers() {
        return handlers;
    }

    private BaseTagIOHandler() {
    }

    static {
        BaseTagIOHandler.handlers[NBTTag.BaseType.END.Id()] = null;
        BaseTagIOHandler.handlers[NBTTag.BaseType.BYTE.Id()] = new BaseTagIOHandler(){

            @Override
            public ByteTag build(byte type, String name, Object payload) {
                return new ByteTag(name, (Byte)payload);
            }

            @Override
            public Byte read(NBTInputStream in) throws IOException {
                return in.readByte();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeByte(((Byte)payload).byteValue());
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.SHORT.Id()] = new BaseTagIOHandler(){

            @Override
            public ShortTag build(byte type, String name, Object payload) {
                return new ShortTag(name, (Short)payload);
            }

            @Override
            public Short read(NBTInputStream in) throws IOException {
                return in.readShort();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeShort(((Short)payload).shortValue());
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.INTEGER.Id()] = new BaseTagIOHandler(){

            @Override
            public IntegerTag build(byte type, String name, Object payload) {
                return new IntegerTag(name, (Integer)payload);
            }

            @Override
            public Integer read(NBTInputStream in) throws IOException {
                return in.readInt();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeInt((Integer)payload);
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.LONG.Id()] = new BaseTagIOHandler(){

            @Override
            public LongTag build(byte type, String name, Object payload) {
                return new LongTag(name, (Long)payload);
            }

            @Override
            public Long read(NBTInputStream in) throws IOException {
                return in.readLong();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeLong((Long)payload);
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.FLOAT.Id()] = new BaseTagIOHandler(){

            @Override
            public FloatTag build(byte type, String name, Object payload) {
                return new FloatTag(name, ((Float)payload).floatValue());
            }

            @Override
            public Float read(NBTInputStream in) throws IOException {
                return Float.valueOf(in.readFloat());
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeFloat(((Float)payload).floatValue());
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.DOUBLE.Id()] = new BaseTagIOHandler(){

            @Override
            public DoubleTag build(byte type, String name, Object payload) {
                return new DoubleTag(name, (Double)payload);
            }

            @Override
            public Double read(NBTInputStream in) throws IOException {
                return in.readDouble();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeDouble((Double)payload);
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.BYTE_ARRAY.Id()] = new BaseTagIOHandler(){

            @Override
            public ByteArrayTag build(byte type, String name, Object payload) {
                return new ByteArrayTag(name, (byte[])payload);
            }

            public byte[] read(NBTInputStream in) throws IOException {
                byte[] p = new byte[in.readInt()];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = in.readByte();
                }
                return p;
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                byte[] p = (byte[])payload;
                out.writeInt(p.length);
                for (int i = 0; i < p.length; ++i) {
                    out.writeByte(p[i]);
                }
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.STRING.Id()] = new BaseTagIOHandler(){

            @Override
            public StringTag build(byte type, String name, Object payload) {
                return new StringTag(name, (String)payload);
            }

            @Override
            public String read(NBTInputStream in) throws IOException {
                return in.readUTF();
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                out.writeUTF((String)payload);
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.LIST.Id()] = new BaseTagIOHandler(){

            @Override
            public ListTag build(byte type, String name, Object payload) {
                return new ListTag(name, (List)payload);
            }

            @Override
            public List<NBTTag> read(NBTInputStream in) throws IOException {
                byte ct = in.readByte();
                int s = in.readInt();
                ArrayList<NBTTag> r = new ArrayList<NBTTag>();
                for (int i = 0; i < s; ++i) {
                    r.add(new BaseTag(new TagHeader(ct, null), XNBT.getReader(ct).read(in)));
                }
                return r;
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                List list = (List)payload;
                byte ct = list.isEmpty() ? (byte)0 : ((NBTTag)list.get(0)).getHeader().getType();
                int s = list.size();
                out.writeByte(ct);
                out.writeInt(s);
                for (int i = 0; i < s; ++i) {
                    XNBT.getWriter(ct).write(((NBTTag)list.get(i)).getPayload(), out);
                }
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.COMPOUND.Id()] = new BaseTagIOHandler(){

            @Override
            public CompoundTag build(byte type, String name, Object payload) {
                return new CompoundTag(name, (Map)payload);
            }

            @Override
            public Map<String, NBTTag> read(NBTInputStream in) throws IOException {
                NBTTag t;
                HashMap<String, NBTTag> r = new HashMap<String, NBTTag>();
                while (!(t = in.readTag()).equals(BaseTag.ENDTAG)) {
                    r.put(t.getHeader().getName(), t);
                }
                return r;
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                for (NBTTag t : ((Map)payload).values()) {
                    out.writeTag(t);
                }
                out.writeTag(BaseTag.ENDTAG);
            }
        };
        BaseTagIOHandler.handlers[NBTTag.BaseType.INTEGER_ARRAY.Id()] = new BaseTagIOHandler(){

            @Override
            public IntegerArrayTag build(byte type, String name, Object payload) {
                return new IntegerArrayTag(name, (int[])payload);
            }

            public int[] read(NBTInputStream in) throws IOException {
                int[] p = new int[in.readInt()];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = in.readInt();
                }
                return p;
            }

            @Override
            public void write(Object payload, NBTOutputStream out) throws IOException {
                int[] p = (int[])payload;
                out.writeInt(p.length);
                for (int i = 0; i < p.length; ++i) {
                    out.writeInt(p[i]);
                }
            }
        };
    }
}

