/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import java.nio.charset.StandardCharsets;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;

public class CUIChannelHandler
implements RawDataListener {
    public static final String CUI_PLUGIN_CHANNEL = "WECUI";
    private static ChannelBinding.RawDataChannel channel;

    public static void init() {
        channel = Sponge.getChannelRegistrar().createRawChannel((Object)SpongeWorldEdit.inst(), CUI_PLUGIN_CHANNEL);
        channel.addListener(Platform.Type.SERVER, (RawDataListener)new CUIChannelHandler());
    }

    public static ChannelBinding.RawDataChannel getActiveChannel() {
        return channel;
    }

    public void handlePayload(ChannelBuf data, RemoteConnection connection, Platform.Type side) {
        if (connection instanceof PlayerConnection) {
            Player player = ((PlayerConnection)connection).getPlayer();
            LocalSession session = SpongeWorldEdit.inst().getSession(player);
            if (session.hasCUISupport()) {
                return;
            }
            session.handleCUIInitializationMessage(new String(data.readBytes(data.available()), StandardCharsets.UTF_8));
            session.describeCUI(SpongeWorldEdit.inst().wrapPlayer(player));
        }
    }
}

