/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.sk89q.worldedit.util.command.CommandMapping;
import java.util.Optional;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;

public abstract class CommandAdapter
implements CommandCallable {
    private CommandMapping command;

    protected CommandAdapter(CommandMapping command) {
        this.command = command;
    }

    public boolean testPermission(CommandSource source) {
        for (String perm : this.command.getDescription().getPermissions()) {
            if (source.hasPermission(perm)) continue;
            return false;
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        String description = this.command.getDescription().getDescription();
        if (description != null && !description.isEmpty()) {
            return Optional.of(Text.of((String)description));
        }
        return Optional.empty();
    }

    public Optional<Text> getHelp(CommandSource source) {
        String help = this.command.getDescription().getHelp();
        if (help != null && !help.isEmpty()) {
            return Optional.of(Text.of((String)help));
        }
        return Optional.empty();
    }

    public Text getUsage(CommandSource source) {
        return Text.of((String)this.command.getDescription().getUsage());
    }
}

