/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.biome.BiomeType;

class SpongeBiomeRegistry
implements BiomeRegistry {
    SpongeBiomeRegistry() {
    }

    @Override
    @Nullable
    public BaseBiome createFromId(int id) {
        return new BaseBiome(id);
    }

    @Override
    public List<BaseBiome> getBiomes() {
        ArrayList<BaseBiome> list = new ArrayList<BaseBiome>();
        for (BiomeType biome : Sponge.getGame().getRegistry().getAllOf(BiomeType.class)) {
            list.add(new BaseBiome(SpongeWorldEdit.inst().getAdapter().resolve(biome)));
        }
        return list;
    }

    @Override
    @Nullable
    public BiomeData getData(BaseBiome biome) {
        return new SpongeBiomeData(SpongeWorldEdit.inst().getAdapter().resolveBiome(biome.getId()));
    }

    private static class SpongeBiomeData
    implements BiomeData {
        private final BiomeType biome;

        private SpongeBiomeData(BiomeType biome) {
            this.biome = biome;
        }

        @Override
        public String getName() {
            return this.biome.getName();
        }
    }
}

