/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeCommandSender
implements Actor {
    private static final UUID DEFAULT_ID = UUID.fromString("a233eb4b-4cab-42cd-9fd9-7e7b9a3f74be");
    private CommandSource sender;
    private SpongeWorldEdit plugin;

    public SpongeCommandSender(SpongeWorldEdit plugin, CommandSource sender) {
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkArgument((!(sender instanceof Player) ? 1 : 0) != 0, (Object)"Cannot wrap a player");
        this.plugin = plugin;
        this.sender = sender;
    }

    @Override
    public UUID getUniqueId() {
        return DEFAULT_ID;
    }

    @Override
    public String getName() {
        return this.sender.getName();
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(part));
        }
    }

    @Override
    public void print(String msg) {
        this.sendColorized(msg, TextColors.LIGHT_PURPLE);
    }

    @Override
    public void printDebug(String msg) {
        this.sendColorized(msg, TextColors.GRAY);
    }

    @Override
    public void printError(String msg) {
        this.sendColorized(msg, TextColors.RED);
    }

    private void sendColorized(String msg, TextColor formatting) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage(Text.of((Object[])new Object[]{formatting, TextSerializers.LEGACY_FORMATTING_CODE.deserialize(part)}));
        }
    }

    @Override
    public boolean canDestroyBedrock() {
        return true;
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public boolean hasPermission(String perm) {
        return true;
    }

    @Override
    public void checkPermission(String permission) throws AuthorizationException {
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    @Override
    public File openFileOpenDialog(String[] extensions) {
        return null;
    }

    @Override
    public File openFileSaveDialog(String[] extensions) {
        return null;
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKey(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public boolean isPersistent() {
                return false;
            }

            @Override
            public UUID getUniqueId() {
                return DEFAULT_ID;
            }
        };
    }
}

