/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.metadata.EntityType;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.sponge.SpongeEntityType;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.world.NullWorld;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

class SpongeEntity
implements Entity {
    private final WeakReference<org.spongepowered.api.entity.Entity> entityRef;

    SpongeEntity(org.spongepowered.api.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entityRef = new WeakReference<org.spongepowered.api.entity.Entity>(entity);
    }

    @Override
    public BaseEntity getState() {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)this.entityRef.get();
        if (entity != null) {
            return SpongeWorldEdit.inst().getAdapter().createBaseEntity(entity);
        }
        return null;
    }

    @Override
    public com.sk89q.worldedit.util.Location getLocation() {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)this.entityRef.get();
        if (entity != null) {
            Location entityLoc = entity.getLocation();
            Vector3d entityRot = entity.getRotation();
            return SpongeWorldEdit.inst().getAdapter().adapt((Location<World>)entityLoc, entityRot);
        }
        return new com.sk89q.worldedit.util.Location(NullWorld.getInstance());
    }

    @Override
    public Extent getExtent() {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)this.entityRef.get();
        if (entity != null) {
            return SpongeWorldEdit.inst().getAdapter().getWorld(entity.getWorld());
        }
        return NullWorld.getInstance();
    }

    @Override
    public boolean remove() {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)this.entityRef.get();
        if (entity != null) {
            entity.remove();
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        org.spongepowered.api.entity.Entity entity = (org.spongepowered.api.entity.Entity)this.entityRef.get();
        if (entity != null) {
            if (EntityType.class.isAssignableFrom(cls)) {
                return (T)new SpongeEntityType(entity);
            }
            return null;
        }
        return null;
    }
}

