/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.metadata.EntityType;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.explosive.PrimedTNT;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.entity.hanging.Painting;
import org.spongepowered.api.entity.living.Ambient;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.Villager;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.complex.ComplexLivingPart;
import org.spongepowered.api.entity.living.golem.Golem;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.vehicle.Boat;
import org.spongepowered.api.entity.vehicle.minecart.Minecart;
import org.spongepowered.api.text.Text;

public class SpongeEntityType
implements EntityType {
    private final Entity entity;

    public SpongeEntityType(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
    }

    @Override
    public boolean isPlayerDerived() {
        return this.entity instanceof Humanoid;
    }

    @Override
    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    @Override
    public boolean isItem() {
        return this.entity instanceof Item;
    }

    @Override
    public boolean isFallingBlock() {
        return this.entity instanceof FallingBlock;
    }

    @Override
    public boolean isPainting() {
        return this.entity instanceof Painting;
    }

    @Override
    public boolean isItemFrame() {
        return this.entity instanceof ItemFrame;
    }

    @Override
    public boolean isBoat() {
        return this.entity instanceof Boat;
    }

    @Override
    public boolean isMinecart() {
        return this.entity instanceof Minecart;
    }

    @Override
    public boolean isTNT() {
        return this.entity instanceof PrimedTNT;
    }

    @Override
    public boolean isExperienceOrb() {
        return this.entity instanceof ExperienceOrb;
    }

    @Override
    public boolean isLiving() {
        return this.entity instanceof Living;
    }

    @Override
    public boolean isAnimal() {
        return this.entity instanceof Animal;
    }

    @Override
    public boolean isAmbient() {
        return this.entity instanceof Ambient;
    }

    @Override
    public boolean isNPC() {
        return this.entity instanceof Villager;
    }

    @Override
    public boolean isGolem() {
        return this.entity instanceof Golem;
    }

    @Override
    public boolean isTamed() {
        return this.entity.get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public boolean isTagged() {
        return !this.entity.get(Keys.DISPLAY_NAME).orElse(Text.EMPTY).isEmpty();
    }

    @Override
    public boolean isArmorStand() {
        return this.entity instanceof ArmorStand;
    }

    @Override
    public boolean isPasteable() {
        return !(this.entity instanceof Player) && !(this.entity instanceof ComplexLivingPart);
    }
}

