/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectReference;

public class SpongePermissionsProvider {
    public boolean hasPermission(Player player, String permission) {
        return player.hasPermission(permission);
    }

    public void registerPermission(CommandCallable command, String permission) {
        Sponge.getGame().getServiceManager().getRegistration(PermissionService.class).ifPresent(permissionService -> {
            PermissionDescription.Builder permissionBuilder = ((PermissionService)permissionService.getProvider()).newDescriptionBuilder((Object)SpongeWorldEdit.inst());
            permissionBuilder.id(permission).register();
        });
    }

    public String[] getGroups(Player player) {
        return player.getParents().stream().map(SubjectReference::getSubjectIdentifier).collect(Collectors.toList()).toArray(new String[0]);
    }
}

