/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.sponge.CommandAdapter;
import com.sk89q.worldedit.sponge.SpongePlayer;
import com.sk89q.worldedit.sponge.SpongeWorld;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.sponge.config.SpongeConfiguration;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Dispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

class SpongePlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final SpongeWorldEdit mod;
    private boolean hookingEvents = false;

    SpongePlatform(SpongeWorldEdit mod) {
        this.mod = mod;
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    @Override
    public int resolveItem(String name) {
        if (name == null) {
            return 0;
        }
        Optional optBlock = Sponge.getRegistry().getType(BlockType.class, name);
        if (optBlock.isPresent()) {
            return optBlock.map(blockType -> SpongeWorldEdit.inst().getAdapter().resolve((BlockType)blockType)).orElse(0);
        }
        Optional optType = Sponge.getRegistry().getType(ItemType.class, name);
        return optType.map(itemType -> SpongeWorldEdit.inst().getAdapter().resolve((ItemType)itemType)).orElse(0);
    }

    @Override
    public boolean isValidMobType(String type) {
        return Sponge.getRegistry().getType(EntityType.class, type).isPresent();
    }

    @Override
    public void reload() {
        this.getConfiguration().load();
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        Task.builder().delayTicks(delay).intervalTicks(period).execute(task).submit((Object)SpongeWorldEdit.inst());
        return 0;
    }

    @Override
    public List<? extends com.sk89q.worldedit.world.World> getWorlds() {
        Collection worlds = Sponge.getServer().getWorlds();
        ArrayList<SpongeWorld> ret = new ArrayList<SpongeWorld>(worlds.size());
        for (World world : worlds) {
            ret.add(SpongeWorldEdit.inst().getAdapter().getWorld(world));
        }
        return ret;
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.entity.Player matchPlayer(com.sk89q.worldedit.entity.Player player) {
        if (player instanceof SpongePlayer) {
            return player;
        }
        Optional optPlayer = Sponge.getServer().getPlayer(player.getUniqueId());
        return optPlayer.map(player1 -> new SpongePlayer(this, (Player)player1)).orElse(null);
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.world.World matchWorld(com.sk89q.worldedit.world.World world) {
        if (world instanceof SpongeWorld) {
            return world;
        }
        for (World ws : Sponge.getServer().getWorlds()) {
            if (!ws.getName().equals(world.getName())) continue;
            return SpongeWorldEdit.inst().getAdapter().getWorld(ws);
        }
        return null;
    }

    @Override
    public void registerCommands(Dispatcher dispatcher) {
        for (final CommandMapping command : dispatcher.getCommands()) {
            CommandAdapter adapter = new CommandAdapter(command){

                public CommandResult process(CommandSource source, String arguments) throws CommandException {
                    CommandEvent weEvent = new CommandEvent(SpongeWorldEdit.inst().wrapCommandSource(source), command.getPrimaryAlias() + " " + arguments);
                    WorldEdit.getInstance().getEventBus().post(weEvent);
                    return weEvent.isCancelled() ? CommandResult.success() : CommandResult.empty();
                }

                public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) throws CommandException {
                    CommandSuggestionEvent weEvent = new CommandSuggestionEvent(SpongeWorldEdit.inst().wrapCommandSource(source), command.getPrimaryAlias() + " " + arguments);
                    WorldEdit.getInstance().getEventBus().post(weEvent);
                    return weEvent.getSuggestions();
                }
            };
            Sponge.getCommandManager().register((Object)SpongeWorldEdit.inst(), (CommandCallable)adapter, command.getAllAliases());
        }
    }

    @Override
    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    @Override
    public SpongeConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    @Override
    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getPlatformName() {
        return "Sponge-Official";
    }

    @Override
    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.NORMAL);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    @Override
    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            users.add(new SpongePlayer(this, player));
        }
        return users;
    }
}

