/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.flowpowered.math.vector.Vector3d;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.sponge.CUIChannelHandler;
import com.sk89q.worldedit.sponge.SpongePlatform;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.sponge.ThreadSafeCache;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class SpongePlayer
extends AbstractPlayerActor {
    private final Player player;

    protected SpongePlayer(SpongePlatform platform, Player player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public int getItemInHand() {
        Optional is = this.player.getItemInHand(HandTypes.MAIN_HAND);
        return is.map(itemStack -> SpongeWorldEdit.inst().getAdapter().resolve(itemStack.getItem())).orElse(0);
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public com.sk89q.worldedit.util.Location getLocation() {
        Location entityLoc = this.player.getLocation();
        Vector3d entityRot = this.player.getRotation();
        return SpongeWorldEdit.inst().getAdapter().adapt((Location<World>)entityLoc, entityRot);
    }

    @Override
    public WorldVector getPosition() {
        Vector3d pos = this.player.getLocation().getPosition();
        return new WorldVector((LocalWorld)LocalWorldAdapter.adapt(SpongeWorldEdit.inst().getAdapter().getWorld(this.player.getWorld())), pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public com.sk89q.worldedit.world.World getWorld() {
        return SpongeWorldEdit.inst().getAdapter().getWorld(this.player.getWorld());
    }

    @Override
    public double getPitch() {
        return this.getLocation().getPitch();
    }

    @Override
    public double getYaw() {
        return this.getLocation().getYaw();
    }

    @Override
    public void giveItem(int type, int amt) {
        this.player.getInventory().offer(ItemStack.of((ItemType)SpongeWorldEdit.inst().getAdapter().resolveItem(type), (int)amt));
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        String finalData = send;
        CUIChannelHandler.getActiveChannel().sendTo(this.player, buffer -> buffer.writeBytes(finalData.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(part));
        }
    }

    @Override
    public void printDebug(String msg) {
        this.sendColorized(msg, TextColors.GRAY);
    }

    @Override
    public void print(String msg) {
        this.sendColorized(msg, TextColors.LIGHT_PURPLE);
    }

    @Override
    public void printError(String msg) {
        this.sendColorized(msg, TextColors.RED);
    }

    private void sendColorized(String msg, TextColor formatting) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(Text.of((Object[])new Object[]{formatting, TextSerializers.LEGACY_FORMATTING_CODE.deserialize(part)}));
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        Location loc = new Location((Extent)this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ());
        this.player.setLocationAndRotation(loc, new Vector3d(pitch, yaw, 0.0f));
    }

    @Override
    public String[] getGroups() {
        return SpongeWorldEdit.inst().getPermissionsProvider().getGroups(this.player);
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public boolean hasPermission(String perm) {
        return SpongeWorldEdit.inst().getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.getUniqueId(), this.player.getName());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

