/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.sponge.SpongeEntity;
import com.sk89q.worldedit.sponge.SpongeWorldData;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.registry.WorldData;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.property.block.GroundLuminanceProperty;
import org.spongepowered.api.data.property.block.SkyLuminanceProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

public abstract class SpongeWorld
extends AbstractWorld {
    private static final Logger log = LoggerFactory.getLogger(SpongeWorld.class);
    private final WeakReference<World> worldRef;
    private static final BlockSnapshot.Builder builder = BlockSnapshot.builder();

    protected SpongeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
    }

    public World getWorldChecked() throws WorldEditException {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return this.getWorld().getName();
    }

    protected abstract BlockState getBlockState(BaseBlock var1);

    protected abstract void applyTileEntityData(TileEntity var1, BaseBlock var2);

    @Override
    public boolean setBlock(Vector position, BaseBlock block, boolean notifyAndLight) throws WorldEditException {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)block);
        World world = this.getWorldChecked();
        Vector3i pos = new Vector3i(position.getX(), position.getY(), position.getZ());
        BlockState newState = this.getBlockState(block);
        BlockSnapshot snapshot = (BlockSnapshot)((BlockSnapshot.Builder)builder.reset()).blockState(newState).position(pos).world(world.getProperties()).build();
        snapshot.restore(true, notifyAndLight ? BlockChangeFlags.ALL : BlockChangeFlags.NONE);
        if (block.hasNbtData()) {
            world.getTileEntity(pos).ifPresent(tileEntity -> this.applyTileEntityData((TileEntity)tileEntity, block));
        }
        return true;
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        WorldProperties tempWorldProperties;
        Server server = Sponge.getServer();
        String id = "regenArchetype" + this.getWorld().getName();
        WorldArchetype regenerationArchetype = Sponge.getRegistry().getType(WorldArchetype.class, id).orElseGet(() -> WorldArchetype.builder().from(this.getWorld().getProperties()).serializationBehavior(SerializationBehaviors.NONE).build(id, id));
        try {
            tempWorldProperties = server.createWorldProperties("worldedittemp", regenerationArchetype);
            tempWorldProperties.setGenerateSpawnOnLoad(false);
        }
        catch (IOException e) {
            log.error("Error creating world properties", (Throwable)e);
            return false;
        }
        Optional tempWorldOpt = server.loadWorld(tempWorldProperties);
        if (!tempWorldOpt.isPresent()) {
            log.error("Failed to load temp world");
            return false;
        }
        World freshWorld = (World)tempWorldOpt.get();
        try {
            CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
            for (Vector2D chunk : expandedPreGen.getChunks()) {
                freshWorld.getChunk(chunk.getBlockX(), 0, chunk.getBlockZ());
            }
            SpongeWorld from = SpongeWorldEdit.inst().getWorld(freshWorld);
            for (BlockVector vec : region) {
                editSession.setBlock((Vector)vec, from.getBlock(vec));
            }
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        finally {
            server.unloadWorld(freshWorld);
            server.deleteWorld(tempWorldProperties);
        }
        return true;
    }

    @Override
    public int getBlockLightLevel(Vector position) {
        Preconditions.checkNotNull((Object)position);
        BlockState state = this.getWorld().getBlock(new Vector3i(position.getX(), position.getY(), position.getZ()));
        Optional groundLuminanceProperty = state.getProperty(GroundLuminanceProperty.class);
        Optional skyLuminanceProperty = state.getProperty(SkyLuminanceProperty.class);
        if (!groundLuminanceProperty.isPresent() || !skyLuminanceProperty.isPresent()) {
            return 0;
        }
        return (int)Math.max((Double)((GroundLuminanceProperty)groundLuminanceProperty.get()).getValue(), (Double)((SkyLuminanceProperty)skyLuminanceProperty.get()).getValue());
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        Preconditions.checkNotNull((Object)position);
        return new BaseBiome(SpongeWorldEdit.inst().getAdapter().resolve(this.getWorld().getBiome(position.getBlockX(), 0, position.getBlockZ())));
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        this.getWorld().setBiome(position.getBlockX(), 0, position.getBlockZ(), SpongeWorldEdit.inst().getAdapter().resolveBiome(biome.getId()));
        return true;
    }

    @Override
    public void dropItem(Vector position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == 0) {
            return;
        }
        Entity entity = this.getWorld().createEntity(EntityTypes.ITEM, new Vector3d(position.getX(), position.getY(), position.getZ()));
        entity.offer(Keys.REPRESENTED_ITEM, (Object)SpongeWorldEdit.toSpongeItemStack(item).createSnapshot());
        this.getWorld().spawnEntity(entity);
    }

    @Override
    public WorldData getWorldData() {
        return SpongeWorldData.getInstance();
    }

    @Override
    public boolean isValidBlockType(int id) {
        return id == 0 || SpongeWorldEdit.inst().getAdapter().resolveBlock(id) != null;
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SpongeWorld) {
            SpongeWorld other = (SpongeWorld)o;
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && thisWorld != null && otherWorld.equals(thisWorld);
        }
        return o instanceof com.sk89q.worldedit.world.World && ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities(Region region) {
        ArrayList<SpongeEntity> entities = new ArrayList<SpongeEntity>();
        for (Entity entity : this.getWorld().getEntities()) {
            org.spongepowered.api.world.Location loc = entity.getLocation();
            if (!region.contains(new Vector(loc.getX(), loc.getY(), loc.getZ()))) continue;
            entities.add(new SpongeEntity(entity));
        }
        return entities;
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities() {
        ArrayList<SpongeEntity> entities = new ArrayList<SpongeEntity>();
        for (Entity entity : this.getWorld().getEntities()) {
            entities.add(new SpongeEntity(entity));
        }
        return entities;
    }

    protected abstract void applyEntityData(Entity var1, BaseEntity var2);

    @Override
    @Nullable
    public com.sk89q.worldedit.entity.Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        EntityType entityType = (EntityType)Sponge.getRegistry().getType(EntityType.class, entity.getTypeId()).get();
        Vector3d pos = new Vector3d(location.getX(), location.getY(), location.getZ());
        Entity newEnt = world.createEntity(entityType, pos);
        if (entity.hasNbtData()) {
            this.applyEntityData(newEnt, entity);
        }
        Vector dir = location.getDirection();
        newEnt.setLocationAndRotation(new org.spongepowered.api.world.Location((Extent)this.getWorld(), pos), new Vector3d(dir.getX(), dir.getY(), dir.getZ()));
        if (world.spawnEntity(newEnt)) {
            return new SpongeEntity(newEnt);
        }
        return null;
    }

    private static class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

