/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.sponge.CUIChannelHandler;
import com.sk89q.worldedit.sponge.SpongeCommandSender;
import com.sk89q.worldedit.sponge.SpongePermissionsProvider;
import com.sk89q.worldedit.sponge.SpongePlatform;
import com.sk89q.worldedit.sponge.SpongePlayer;
import com.sk89q.worldedit.sponge.SpongeWorld;
import com.sk89q.worldedit.sponge.ThreadSafeCache;
import com.sk89q.worldedit.sponge.adapter.AdapterLoadException;
import com.sk89q.worldedit.sponge.adapter.SpongeImplAdapter;
import com.sk89q.worldedit.sponge.adapter.SpongeImplLoader;
import com.sk89q.worldedit.sponge.config.SpongeConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.state.GameAboutToStartServerEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Plugin(id="worldedit", name="WorldEdit", description="WorldEdit is an easy-to-use in-game world editor for Minecraft", url="http://www.enginehub.org/worldedit")
public class SpongeWorldEdit {
    @Inject
    private Logger logger;
    public static final String MOD_ID = "worldedit";
    private SpongePermissionsProvider provider;
    @Inject
    private PluginContainer container;
    private static SpongeWorldEdit inst;
    private SpongePlatform platform;
    private SpongeImplAdapter spongeAdapter;
    @Inject
    private SpongeConfiguration config;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File workingDir;

    public static PluginContainer container() {
        return SpongeWorldEdit.inst.container;
    }

    public static SpongeWorldEdit inst() {
        return inst;
    }

    public SpongeWorldEdit() {
        inst = this;
    }

    @Listener
    public void preInit(GamePreInitializationEvent event) {
        this.config.load();
        Task.builder().interval(30L, TimeUnit.SECONDS).execute((Runnable)ThreadSafeCache.getInstance()).submit((Object)this);
    }

    @Listener
    public void init(GameInitializationEvent event) {
        CUIChannelHandler.init();
    }

    @Listener
    public void postInit(GamePostInitializationEvent event) {
        this.logger.info("WorldEdit for Sponge (version " + this.getInternalVersion() + ") is loaded");
    }

    @Listener
    public void serverAboutToStart(GameAboutToStartServerEvent event) {
        if (this.platform != null) {
            this.logger.warn("GameAboutToStartServerEvent occurred when GameStoppingServerEvent hasn't");
            WorldEdit.getInstance().getPlatformManager().unregister(this.platform);
        }
        this.platform = new SpongePlatform(this);
        this.provider = new SpongePermissionsProvider();
        WorldEdit.getInstance().getPlatformManager().register(this.platform);
    }

    @Listener
    public void serverStopping(GameStoppingServerEvent event) {
        WorldEdit.getInstance().getPlatformManager().unregister(this.platform);
    }

    @Listener
    public void serverStarted(GameStartedServerEvent event) {
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent());
        this.loadAdapter();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        SpongeImplLoader adapterLoader = new SpongeImplLoader();
        try {
            adapterLoader.addFromPath(this.getClass().getClassLoader());
        }
        catch (IOException e) {
            this.logger.warn("Failed to search path for Sponge adapters");
        }
        try {
            adapterLoader.addFromJar(((Path)this.container.getSource().get()).toFile());
        }
        catch (IOException e) {
            this.logger.warn("Failed to search " + ((Path)this.container.getSource().get()).toFile() + " for Sponge adapters", (Throwable)e);
        }
        try {
            this.spongeAdapter = adapterLoader.loadAdapter();
            this.logger.info("Using " + this.spongeAdapter.getClass().getCanonicalName() + " as the Sponge adapter");
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof SpongePlatform) {
                this.logger.warn(e.getMessage());
            }
            this.logger.info("WorldEdit could not find a Sponge adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
        }
    }

    public SpongeImplAdapter getAdapter() {
        return this.spongeAdapter;
    }

    @Listener
    public void onPlayerItemInteract(InteractItemEvent.Secondary event, @Root Player spongePlayer) {
        SpongePlayer player;
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        if (we.handleRightClick(player = this.wrapPlayer(spongePlayer))) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onPlayerInteract(InteractBlockEvent event, @Root Player spongePlayer) {
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        SpongePlayer player = this.wrapPlayer(spongePlayer);
        com.sk89q.worldedit.world.World world = player.getWorld();
        BlockSnapshot targetBlock = event.getTargetBlock();
        Optional optLoc = targetBlock.getLocation();
        BlockType interactedType = targetBlock.getState().getType();
        if (event instanceof InteractBlockEvent.Primary) {
            if (interactedType != BlockTypes.AIR) {
                if (!optLoc.isPresent()) {
                    return;
                }
                Location loc = (Location)optLoc.get();
                WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), loc.getX(), loc.getY(), loc.getZ());
                if (we.handleBlockLeftClick(player, pos)) {
                    event.setCancelled(true);
                }
                if (we.handleArmSwing(player)) {
                    event.setCancelled(true);
                }
            } else if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (event instanceof InteractBlockEvent.Secondary) {
            if (!optLoc.isPresent()) {
                return;
            }
            Location loc = (Location)optLoc.get();
            WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), loc.getX(), loc.getY(), loc.getZ());
            if (we.handleBlockRightClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        }
    }

    public static ItemStack toSpongeItemStack(BaseItemStack item) {
        return SpongeWorldEdit.inst().getAdapter().makeSpongeStack(item);
    }

    SpongeConfiguration getConfig() {
        return this.config;
    }

    public SpongePlayer wrapPlayer(Player player) {
        Preconditions.checkNotNull((Object)player);
        return new SpongePlayer(this.platform, player);
    }

    public Actor wrapCommandSource(CommandSource sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        return new SpongeCommandSender(this, sender);
    }

    public LocalSession getSession(Player player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get(this.wrapPlayer(player));
    }

    public SpongeWorld getWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        return this.getAdapter().getWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    String getInternalVersion() {
        return this.container.getVersion().orElse("Unknown");
    }

    public void setPermissionsProvider(SpongePermissionsProvider provider) {
        this.provider = provider;
    }

    public SpongePermissionsProvider getPermissionsProvider() {
        return this.provider;
    }
}

