/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.adapter;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.sponge.adapter.AdapterLoadException;
import com.sk89q.worldedit.sponge.adapter.SpongeImplAdapter;
import com.sk89q.worldedit.util.io.Closer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpongeImplLoader {
    private static final Logger log = Logger.getLogger(SpongeImplLoader.class.getCanonicalName());
    private final List<String> adapterCandidates = new ArrayList<String>();
    private String customCandidate;
    private static final String SEARCH_PACKAGE = "com.sk89q.worldedit.sponge.adapter.impl";
    private static final String SEARCH_PACKAGE_DOT = "com.sk89q.worldedit.sponge.adapter.impl.";
    private static final String SEARCH_PATH = "com.sk89q.worldedit.sponge.adapter.impl".replace(".", "/");
    private static final String CLASS_SUFFIX = ".class";
    private static final String LOAD_ERROR_MESSAGE = "\n**********************************************\n** This WorldEdit version does not support your version of Sponge.\n** WorldEdit will not function! \n** \n** Please ensure you are running the latest version\n**********************************************\n";

    public SpongeImplLoader() {
        this.addDefaults();
    }

    private void addDefaults() {
        String className = System.getProperty("worldedit.sponge.adapter");
        if (className != null) {
            this.customCandidate = className;
            this.adapterCandidates.add(className);
            log.log(Level.INFO, "-Dworldedit.sponge.adapter used to add " + className + " to the list of available Sponge adapters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromJar(File file) throws IOException {
        Closer closer = Closer.create();
        JarFile jar = closer.register(new JarFile(file));
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String className = jarEntry.getName().replaceAll("[/\\\\]+", ".");
                if (!className.startsWith(SEARCH_PACKAGE_DOT) || jarEntry.isDirectory() || className.contains("$")) continue;
                int beginIndex = 0;
                int endIndex = className.length() - CLASS_SUFFIX.length();
                className = className.substring(beginIndex, endIndex);
                this.adapterCandidates.add(className);
            }
        }
        finally {
            closer.close();
        }
    }

    public void addFromPath(ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(SEARCH_PATH);
        while (resources.hasMoreElements()) {
            File file = new File(resources.nextElement().getFile());
            this.addFromPath(file);
        }
    }

    private void addFromPath(File file) {
        int endIndex;
        int beginIndex;
        String className;
        String resource = SEARCH_PACKAGE_DOT + file.getName();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.addFromPath(child);
                }
            }
        } else if (resource.endsWith(CLASS_SUFFIX) && !(className = resource.substring(beginIndex = 0, endIndex = resource.length() - CLASS_SUFFIX.length())).contains("$")) {
            this.adapterCandidates.add(className);
        }
    }

    public SpongeImplAdapter loadAdapter() throws AdapterLoadException {
        ArrayList suitableAdapters = Lists.newArrayList();
        for (String className : this.adapterCandidates) {
            try {
                Class<?> cls = Class.forName(className);
                if (SpongeImplAdapter.class.isAssignableFrom(cls)) {
                    suitableAdapters.add((SpongeImplAdapter)cls.newInstance());
                    continue;
                }
                log.log(Level.WARNING, "Failed to load the Sponge adapter class '" + className + "' because it does not implement " + SpongeImplAdapter.class.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, "Failed to load the Sponge adapter class '" + className + "' that is not supposed to be missing", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.WARNING, "Failed to load the Sponge adapter class '" + className + "' that is not supposed to be raising this error", e);
            }
            catch (Throwable e) {
                if (!className.equals(this.customCandidate)) continue;
                log.log(Level.WARNING, "Failed to load the Sponge adapter class '" + className + "'", e);
            }
        }
        if (suitableAdapters.isEmpty()) {
            throw new AdapterLoadException(LOAD_ERROR_MESSAGE);
        }
        if (suitableAdapters.size() == 1) {
            return (SpongeImplAdapter)suitableAdapters.get(0);
        }
        return (SpongeImplAdapter)suitableAdapters.stream().sorted((o1, o2) -> {
            if (o1.isBest() && !o2.isBest()) {
                return -1;
            }
            if (!o1.isBest() && o2.isBest()) {
                return 1;
            }
            return 0;
        }).findFirst().orElse(suitableAdapters.get(0));
    }
}

