/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.adapter.impl;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.LazyBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.sponge.SpongeWorld;
import com.sk89q.worldedit.sponge.adapter.SpongeImplAdapter;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;

public class Sponge_1_10_Impl
implements SpongeImplAdapter {
    private static final ars JUNGLE_LOG = akg.r.u().a((asi)anu.b, (Comparable)anx.a.d);
    private static final ars JUNGLE_LEAF = akg.t.u().a((asi)ant.e, (Comparable)anx.a.d).a((asi)amy.b, (Comparable)Boolean.FALSE);
    private static final ars JUNGLE_SHRUB = akg.t.u().a((asi)ant.e, (Comparable)anx.a.a).a((asi)amy.b, (Comparable)Boolean.FALSE);

    @Override
    public int resolve(ItemType type) {
        return adx.a((adx)((adx)type));
    }

    @Override
    public int resolve(BlockType type) {
        return akf.a((akf)((akf)type));
    }

    @Override
    public int resolve(BiomeType type) {
        return aiq.a((aiq)((aiq)type));
    }

    @Override
    public ItemType resolveItem(int intID) {
        return (ItemType)adx.c((int)intID);
    }

    @Override
    public BlockType resolveBlock(int intID) {
        return (BlockType)akf.b((int)intID);
    }

    @Override
    public BiomeType resolveBiome(int intID) {
        return (BiomeType)aiq.b((int)intID);
    }

    public ef toNative(Tag tag) {
        if (tag instanceof IntArrayTag) {
            return this.toNative((IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return this.toNative((ListTag)tag);
        }
        if (tag instanceof LongTag) {
            return this.toNative((LongTag)tag);
        }
        if (tag instanceof StringTag) {
            return this.toNative((StringTag)tag);
        }
        if (tag instanceof IntTag) {
            return this.toNative((IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return this.toNative((ByteTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return this.toNative((ByteArrayTag)tag);
        }
        if (tag instanceof CompoundTag) {
            return this.toNative((CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return this.toNative((FloatTag)tag);
        }
        if (tag instanceof ShortTag) {
            return this.toNative((ShortTag)tag);
        }
        if (tag instanceof DoubleTag) {
            return this.toNative((DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public dv toNative(IntArrayTag tag) {
        int[] value = tag.getValue();
        return new dv(Arrays.copyOf(value, value.length));
    }

    public dx toNative(ListTag tag) {
        dx list = new dx();
        Iterator iterator = tag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag child = (Tag)iterator.next();
            if (child instanceof EndTag) continue;
            list.a(this.toNative(child));
        }
        return list;
    }

    public dy toNative(LongTag tag) {
        return new dy(tag.getValue().longValue());
    }

    public ee toNative(StringTag tag) {
        return new ee(tag.getValue());
    }

    public dw toNative(IntTag tag) {
        return new dw(tag.getValue().intValue());
    }

    public dq toNative(ByteTag tag) {
        return new dq(tag.getValue().byteValue());
    }

    public dp toNative(ByteArrayTag tag) {
        byte[] value = tag.getValue();
        return new dp(Arrays.copyOf(value, value.length));
    }

    public dr toNative(CompoundTag tag) {
        dr compound = new dr();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.a((String)child.getKey(), this.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public du toNative(FloatTag tag) {
        return new du(tag.getValue().floatValue());
    }

    public ed toNative(ShortTag tag) {
        return new ed(tag.getValue().shortValue());
    }

    public ds toNative(DoubleTag tag) {
        return new ds(tag.getValue().doubleValue());
    }

    public Tag fromNative(ef other) {
        if (other instanceof dv) {
            return this.fromNative((dv)other);
        }
        if (other instanceof dx) {
            return this.fromNative((dx)other);
        }
        if (other instanceof dt) {
            return this.fromNative((dt)other);
        }
        if (other instanceof dy) {
            return this.fromNative((dy)other);
        }
        if (other instanceof ee) {
            return this.fromNative((ee)other);
        }
        if (other instanceof dw) {
            return this.fromNative((dw)other);
        }
        if (other instanceof dq) {
            return this.fromNative((dq)other);
        }
        if (other instanceof dp) {
            return this.fromNative((dp)other);
        }
        if (other instanceof dr) {
            return this.fromNative((dr)other);
        }
        if (other instanceof du) {
            return this.fromNative((du)other);
        }
        if (other instanceof ed) {
            return this.fromNative((ed)other);
        }
        if (other instanceof ds) {
            return this.fromNative((ds)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public IntArrayTag fromNative(dv other) {
        int[] value = other.d();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public ListTag fromNative(dx other) {
        other = other.d();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = StringTag.class;
        int tags = other.c();
        for (int i = 0; i < tags; ++i) {
            Tag child = this.fromNative(other.a(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public EndTag fromNative(dt other) {
        return new EndTag();
    }

    public LongTag fromNative(dy other) {
        return new LongTag(other.d());
    }

    public StringTag fromNative(ee other) {
        return new StringTag(other.c_());
    }

    public IntTag fromNative(dw other) {
        return new IntTag(other.e());
    }

    public ByteTag fromNative(dq other) {
        return new ByteTag(other.g());
    }

    public ByteArrayTag fromNative(dp other) {
        byte[] value = other.c();
        return new ByteArrayTag(Arrays.copyOf(value, value.length));
    }

    public CompoundTag fromNative(dr other) {
        Set tags = other.c();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, this.fromNative(other.c(tagName)));
        }
        return new CompoundTag(map);
    }

    public FloatTag fromNative(du other) {
        return new FloatTag(other.i());
    }

    public ShortTag fromNative(ed other) {
        return new ShortTag(other.f());
    }

    public DoubleTag fromNative(ds other) {
        return new DoubleTag(other.h());
    }

    @Override
    public ItemStack makeSpongeStack(BaseItemStack itemStack) {
        adz newStack = new adz(adx.c((int)itemStack.getType()), itemStack.getAmount(), (int)itemStack.getData());
        for (Map.Entry<Integer, Integer> entry : itemStack.getEnchantments().entrySet()) {
            newStack.a(agv.c((int)entry.getKey()), entry.getValue().intValue());
        }
        return (ItemStack)newStack;
    }

    @Override
    public BaseEntity createBaseEntity(Entity entity) {
        String id = entity.getType().getId();
        dr tag = new dr();
        ((rw)entity).e(tag);
        return new BaseEntity(id, this.fromNative(tag));
    }

    @Override
    public SpongeWorld getWorld(World world) {
        return new SpongeNMSWorld(world);
    }

    @Override
    public boolean isBest() {
        return Sponge.getPlatform().getMinecraftVersion().getName().contains("1.10");
    }

    private class TileEntityBaseBlock
    extends BaseBlock
    implements TileEntityBlock {
        TileEntityBaseBlock(int type, int data, aqk tile) {
            super(type, data);
            this.setNbtData(Sponge_1_10_Impl.this.fromNative(this.copyNbtData(tile)));
        }

        private dr copyNbtData(aqk tile) {
            dr tag = new dr();
            tile.b(tag);
            return tag;
        }
    }

    private class SpongeNMSWorld
    extends SpongeWorld {
        public SpongeNMSWorld(World world) {
            super(world);
        }

        @Override
        protected BlockState getBlockState(BaseBlock block) {
            return (BlockState)akf.b((int)block.getId()).a(block.getData());
        }

        private dr updateForSet(dr tag, Vector position) {
            Preconditions.checkNotNull((Object)tag);
            Preconditions.checkNotNull((Object)position);
            tag.a("x", (ef)new dw(position.getBlockX()));
            tag.a("y", (ef)new dw(position.getBlockY()));
            tag.a("z", (ef)new dw(position.getBlockZ()));
            return tag;
        }

        @Override
        protected void applyTileEntityData(TileEntity entity, BaseBlock block) {
            dr tag = Sponge_1_10_Impl.this.toNative(block.getNbtData());
            Location loc = entity.getLocation();
            this.updateForSet(tag, new Vector(loc.getX(), loc.getY(), loc.getZ()));
            ((aqk)entity).a(tag);
        }

        @Override
        protected void applyEntityData(Entity entity, BaseEntity data) {
            dr tag = Sponge_1_10_Impl.this.toNative(data.getNbtData());
            for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                tag.q(name);
            }
            ((rw)entity).f(tag);
        }

        @Override
        public boolean clearContainerBlockContents(Vector position) {
            cm pos = new cm(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            aqk tile = ((aid)this.getWorld()).r(pos);
            if (tile instanceof ql) {
                ql inv = (ql)tile;
                int size = inv.u_();
                for (int i = 0; i < size; ++i) {
                    inv.a(i, null);
                }
                return true;
            }
            return false;
        }

        @Nullable
        private aut createWorldGenerator(TreeGenerator.TreeType type) {
            switch (type) {
                case TREE: {
                    return new avx(true);
                }
                case BIG_TREE: {
                    return new aug(true);
                }
                case REDWOOD: {
                    return new avu(true);
                }
                case TALL_REDWOOD: {
                    return new avm();
                }
                case BIRCH: {
                    return new auh(true, false);
                }
                case JUNGLE: {
                    return new avg(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
                }
                case SMALL_JUNGLE: {
                    return new avx(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
                }
                case SHORT_JUNGLE: {
                    return new avx(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
                }
                case JUNGLE_BUSH: {
                    return new auw(JUNGLE_LOG, JUNGLE_SHRUB);
                }
                case RED_MUSHROOM: {
                    return new avb(akg.bg);
                }
                case BROWN_MUSHROOM: {
                    return new avb(akg.bh);
                }
                case SWAMP: {
                    return new avv();
                }
                case ACACIA: {
                    return new avr(true);
                }
                case DARK_OAK: {
                    return new avp(true);
                }
                case MEGA_REDWOOD: {
                    return new avh(false, ThreadLocalRandom.current().nextBoolean());
                }
                case TALL_BIRCH: {
                    return new auh(true, true);
                }
            }
            return null;
        }

        @Override
        public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pos) throws MaxChangedBlocksException {
            aut generator = this.createWorldGenerator(type);
            return generator != null && generator.b((aid)this.getWorld(), (Random)ThreadLocalRandom.current(), new cm(pos.getX(), pos.getY(), pos.getZ()));
        }

        @Override
        public BaseBlock getBlock(Vector position) {
            World world = this.getWorld();
            cm pos = new cm(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            ars state = ((aid)world).o(pos);
            aqk tile = ((aid)world).r(pos);
            if (tile != null) {
                return new TileEntityBaseBlock(akf.a((akf)state.t()), state.t().e(state), tile);
            }
            return new BaseBlock(akf.a((akf)state.t()), state.t().e(state));
        }

        @Override
        public BaseBlock getLazyBlock(Vector position) {
            World world = this.getWorld();
            cm pos = new cm(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            ars state = ((aid)world).o(pos);
            return new LazyBlock(akf.a((akf)state.t()), state.t().e(state), this, position);
        }
    }
}

