/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.adapter.impl;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.LazyBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.sponge.SpongeWorld;
import com.sk89q.worldedit.sponge.adapter.SpongeImplAdapter;
import com.sk89q.worldedit.util.TreeGenerator;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;

public class Sponge_1_11_2_Impl
implements SpongeImplAdapter {
    private static final atl JUNGLE_LOG = alv.r.t().a((aub)apk.b, (Comparable)apn.a.d);
    private static final atl JUNGLE_LEAF = alv.t.t().a((aub)apj.e, (Comparable)apn.a.d).a((aub)aon.b, (Comparable)Boolean.FALSE);
    private static final atl JUNGLE_SHRUB = alv.t.t().a((aub)apj.e, (Comparable)apn.a.a).a((aub)aon.b, (Comparable)Boolean.FALSE);

    @Override
    public int resolve(ItemType type) {
        return afh.a((afh)((afh)type));
    }

    @Override
    public int resolve(BlockType type) {
        return alu.a((alu)((alu)type));
    }

    @Override
    public int resolve(BiomeType type) {
        return akf.a((akf)((akf)type));
    }

    @Override
    public ItemType resolveItem(int intID) {
        return (ItemType)afh.c((int)intID);
    }

    @Override
    public BlockType resolveBlock(int intID) {
        return (BlockType)alu.b((int)intID);
    }

    @Override
    public BiomeType resolveBiome(int intID) {
        return (BiomeType)akf.b((int)intID);
    }

    public ei toNative(Tag tag) {
        if (tag instanceof IntArrayTag) {
            return this.toNative((IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return this.toNative((ListTag)tag);
        }
        if (tag instanceof LongTag) {
            return this.toNative((LongTag)tag);
        }
        if (tag instanceof StringTag) {
            return this.toNative((StringTag)tag);
        }
        if (tag instanceof IntTag) {
            return this.toNative((IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return this.toNative((ByteTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return this.toNative((ByteArrayTag)tag);
        }
        if (tag instanceof CompoundTag) {
            return this.toNative((CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return this.toNative((FloatTag)tag);
        }
        if (tag instanceof ShortTag) {
            return this.toNative((ShortTag)tag);
        }
        if (tag instanceof DoubleTag) {
            return this.toNative((DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public dy toNative(IntArrayTag tag) {
        int[] value = tag.getValue();
        return new dy(Arrays.copyOf(value, value.length));
    }

    public ea toNative(ListTag tag) {
        ea list = new ea();
        Iterator iterator = tag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag child = (Tag)iterator.next();
            if (child instanceof EndTag) continue;
            list.a(this.toNative(child));
        }
        return list;
    }

    public eb toNative(LongTag tag) {
        return new eb(tag.getValue().longValue());
    }

    public eh toNative(StringTag tag) {
        return new eh(tag.getValue());
    }

    public dz toNative(IntTag tag) {
        return new dz(tag.getValue().intValue());
    }

    public dt toNative(ByteTag tag) {
        return new dt(tag.getValue().byteValue());
    }

    public ds toNative(ByteArrayTag tag) {
        byte[] value = tag.getValue();
        return new ds(Arrays.copyOf(value, value.length));
    }

    public du toNative(CompoundTag tag) {
        du compound = new du();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.a((String)child.getKey(), this.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public dx toNative(FloatTag tag) {
        return new dx(tag.getValue().floatValue());
    }

    public eg toNative(ShortTag tag) {
        return new eg(tag.getValue().shortValue());
    }

    public dv toNative(DoubleTag tag) {
        return new dv(tag.getValue().doubleValue());
    }

    public Tag fromNative(ei other) {
        if (other instanceof dy) {
            return this.fromNative((dy)other);
        }
        if (other instanceof ea) {
            return this.fromNative((ea)other);
        }
        if (other instanceof dw) {
            return this.fromNative((dw)other);
        }
        if (other instanceof eb) {
            return this.fromNative((eb)other);
        }
        if (other instanceof eh) {
            return this.fromNative((eh)other);
        }
        if (other instanceof dz) {
            return this.fromNative((dz)other);
        }
        if (other instanceof dt) {
            return this.fromNative((dt)other);
        }
        if (other instanceof ds) {
            return this.fromNative((ds)other);
        }
        if (other instanceof du) {
            return this.fromNative((du)other);
        }
        if (other instanceof dx) {
            return this.fromNative((dx)other);
        }
        if (other instanceof eg) {
            return this.fromNative((eg)other);
        }
        if (other instanceof dv) {
            return this.fromNative((dv)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public IntArrayTag fromNative(dy other) {
        int[] value = other.d();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public ListTag fromNative(ea other) {
        other = other.d();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = StringTag.class;
        int tags = other.c();
        for (int i = 0; i < tags; ++i) {
            Tag child = this.fromNative(other.a(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public EndTag fromNative(dw other) {
        return new EndTag();
    }

    public LongTag fromNative(eb other) {
        return new LongTag(other.d());
    }

    public StringTag fromNative(eh other) {
        return new StringTag(other.c_());
    }

    public IntTag fromNative(dz other) {
        return new IntTag(other.e());
    }

    public ByteTag fromNative(dt other) {
        return new ByteTag(other.g());
    }

    public ByteArrayTag fromNative(ds other) {
        byte[] value = other.c();
        return new ByteArrayTag(Arrays.copyOf(value, value.length));
    }

    public CompoundTag fromNative(du other) {
        Set tags = other.c();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, this.fromNative(other.c(tagName)));
        }
        return new CompoundTag(map);
    }

    public FloatTag fromNative(dx other) {
        return new FloatTag(other.i());
    }

    public ShortTag fromNative(eg other) {
        return new ShortTag(other.f());
    }

    public DoubleTag fromNative(dv other) {
        return new DoubleTag(other.h());
    }

    @Override
    public ItemStack makeSpongeStack(BaseItemStack itemStack) {
        afj newStack = new afj(afh.c((int)itemStack.getType()), itemStack.getAmount(), (int)itemStack.getData());
        for (Map.Entry<Integer, Integer> entry : itemStack.getEnchantments().entrySet()) {
            newStack.a(aii.c((int)entry.getKey()), entry.getValue().intValue());
        }
        return (ItemStack)newStack;
    }

    @Override
    public BaseEntity createBaseEntity(Entity entity) {
        String id = entity.getType().getId();
        du tag = new du();
        ((sn)entity).e(tag);
        return new BaseEntity(id, this.fromNative(tag));
    }

    @Override
    public SpongeWorld getWorld(World world) {
        return new SpongeNMSWorld(world);
    }

    @Override
    public boolean isBest() {
        return Sponge.getPlatform().getMinecraftVersion().getName().contains("1.11");
    }

    private class TileEntityBaseBlock
    extends BaseBlock
    implements TileEntityBlock {
        TileEntityBaseBlock(int type, int data, asc tile) {
            super(type, data);
            this.setNbtData(Sponge_1_11_2_Impl.this.fromNative(this.copyNbtData(tile)));
        }

        private du copyNbtData(asc tile) {
            du tag = new du();
            tile.b(tag);
            return tag;
        }
    }

    private class SpongeNMSWorld
    extends SpongeWorld {
        public SpongeNMSWorld(World world) {
            super(world);
        }

        @Override
        protected BlockState getBlockState(BaseBlock block) {
            return (BlockState)alu.b((int)block.getId()).a(block.getData());
        }

        private du updateForSet(du tag, Vector position) {
            Preconditions.checkNotNull((Object)tag);
            Preconditions.checkNotNull((Object)position);
            tag.a("x", (ei)new dz(position.getBlockX()));
            tag.a("y", (ei)new dz(position.getBlockY()));
            tag.a("z", (ei)new dz(position.getBlockZ()));
            return tag;
        }

        @Override
        protected void applyTileEntityData(TileEntity entity, BaseBlock block) {
            du tag = Sponge_1_11_2_Impl.this.toNative(block.getNbtData());
            Location loc = entity.getLocation();
            this.updateForSet(tag, new Vector(loc.getX(), loc.getY(), loc.getZ()));
            ((asc)entity).a(tag);
        }

        @Override
        protected void applyEntityData(Entity entity, BaseEntity data) {
            du tag = Sponge_1_11_2_Impl.this.toNative(data.getNbtData());
            for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                tag.q(name);
            }
            ((sn)entity).f(tag);
        }

        @Override
        public boolean clearContainerBlockContents(Vector position) {
            co pos = new co(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            asc tile = ((ajs)this.getWorld()).r(pos);
            if (tile instanceof rc) {
                rc inv = (rc)tile;
                int size = inv.v_();
                for (int i = 0; i < size; ++i) {
                    inv.a(i, afj.a);
                }
                return true;
            }
            return false;
        }

        @Nullable
        private awn createWorldGenerator(TreeGenerator.TreeType type) {
            switch (type) {
                case TREE: {
                    return new axq(true);
                }
                case BIG_TREE: {
                    return new awa(true);
                }
                case REDWOOD: {
                    return new axn(true);
                }
                case TALL_REDWOOD: {
                    return new axf();
                }
                case BIRCH: {
                    return new awb(true, false);
                }
                case JUNGLE: {
                    return new awz(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
                }
                case SMALL_JUNGLE: {
                    return new axq(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
                }
                case SHORT_JUNGLE: {
                    return new axq(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
                }
                case JUNGLE_BUSH: {
                    return new awq(JUNGLE_LOG, JUNGLE_SHRUB);
                }
                case RED_MUSHROOM: {
                    return new awu(alv.bg);
                }
                case BROWN_MUSHROOM: {
                    return new awu(alv.bh);
                }
                case SWAMP: {
                    return new axo();
                }
                case ACACIA: {
                    return new axk(true);
                }
                case DARK_OAK: {
                    return new axi(true);
                }
                case MEGA_REDWOOD: {
                    return new axa(false, ThreadLocalRandom.current().nextBoolean());
                }
                case TALL_BIRCH: {
                    return new awb(true, true);
                }
            }
            return null;
        }

        @Override
        public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pos) throws MaxChangedBlocksException {
            awn generator = this.createWorldGenerator(type);
            return generator != null && generator.b((ajs)this.getWorld(), (Random)ThreadLocalRandom.current(), new co(pos.getX(), pos.getY(), pos.getZ()));
        }

        @Override
        public BaseBlock getBlock(Vector position) {
            World world = this.getWorld();
            co pos = new co(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            atl state = ((ajs)world).o(pos);
            asc tile = ((ajs)world).r(pos);
            if (tile != null) {
                return new TileEntityBaseBlock(alu.a((alu)state.v()), state.v().e(state), tile);
            }
            return new BaseBlock(alu.a((alu)state.v()), state.v().e(state));
        }

        @Override
        public BaseBlock getLazyBlock(Vector position) {
            World world = this.getWorld();
            co pos = new co(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            atl state = ((ajs)world).o(pos);
            return new LazyBlock(alu.a((alu)state.v()), state.v().e(state), this, position);
        }
    }
}

