/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.adapter.impl;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.LazyBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.sponge.SpongeWorld;
import com.sk89q.worldedit.sponge.adapter.SpongeImplAdapter;
import com.sk89q.worldedit.util.TreeGenerator;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;

public class Sponge_1_12_2_Impl
implements SpongeImplAdapter {
    private static final IBlockState JUNGLE_LOG = Blocks.LOG.getDefaultState().withProperty((IProperty)BlockOldLog.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.LEAVES.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE).withProperty((IProperty)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.FALSE);
    private static final IBlockState JUNGLE_SHRUB = Blocks.LEAVES.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.OAK).withProperty((IProperty)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.FALSE);

    @Override
    public int resolve(ItemType type) {
        return Item.getIdFromItem((Item)((Item)type));
    }

    @Override
    public int resolve(BlockType type) {
        return Block.getIdFromBlock((Block)((Block)type));
    }

    @Override
    public int resolve(BiomeType type) {
        return Biome.getIdForBiome((Biome)((Biome)type));
    }

    @Override
    public ItemType resolveItem(int intID) {
        return (ItemType)Item.getItemById((int)intID);
    }

    @Override
    public BlockType resolveBlock(int intID) {
        return (BlockType)Block.getBlockById((int)intID);
    }

    @Override
    public BiomeType resolveBiome(int intID) {
        return (BiomeType)Biome.getBiome((int)intID);
    }

    public NBTBase toNative(Tag tag) {
        if (tag instanceof IntArrayTag) {
            return this.toNative((IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return this.toNative((ListTag)tag);
        }
        if (tag instanceof LongTag) {
            return this.toNative((LongTag)tag);
        }
        if (tag instanceof StringTag) {
            return this.toNative((StringTag)tag);
        }
        if (tag instanceof IntTag) {
            return this.toNative((IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return this.toNative((ByteTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return this.toNative((ByteArrayTag)tag);
        }
        if (tag instanceof CompoundTag) {
            return this.toNative((CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return this.toNative((FloatTag)tag);
        }
        if (tag instanceof ShortTag) {
            return this.toNative((ShortTag)tag);
        }
        if (tag instanceof DoubleTag) {
            return this.toNative((DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public NBTTagIntArray toNative(IntArrayTag tag) {
        int[] value = tag.getValue();
        return new NBTTagIntArray(Arrays.copyOf(value, value.length));
    }

    public NBTTagList toNative(ListTag tag) {
        NBTTagList list = new NBTTagList();
        Iterator iterator = tag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag child = (Tag)iterator.next();
            if (child instanceof EndTag) continue;
            list.appendTag(this.toNative(child));
        }
        return list;
    }

    public NBTTagLong toNative(LongTag tag) {
        return new NBTTagLong(tag.getValue().longValue());
    }

    public NBTTagString toNative(StringTag tag) {
        return new NBTTagString(tag.getValue());
    }

    public NBTTagInt toNative(IntTag tag) {
        return new NBTTagInt(tag.getValue().intValue());
    }

    public NBTTagByte toNative(ByteTag tag) {
        return new NBTTagByte(tag.getValue().byteValue());
    }

    public NBTTagByteArray toNative(ByteArrayTag tag) {
        byte[] value = tag.getValue();
        return new NBTTagByteArray(Arrays.copyOf(value, value.length));
    }

    public NBTTagCompound toNative(CompoundTag tag) {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.setTag((String)child.getKey(), this.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public NBTTagFloat toNative(FloatTag tag) {
        return new NBTTagFloat(tag.getValue().floatValue());
    }

    public NBTTagShort toNative(ShortTag tag) {
        return new NBTTagShort(tag.getValue().shortValue());
    }

    public NBTTagDouble toNative(DoubleTag tag) {
        return new NBTTagDouble(tag.getValue().doubleValue());
    }

    public Tag fromNative(NBTBase other) {
        if (other instanceof NBTTagIntArray) {
            return this.fromNative((NBTTagIntArray)other);
        }
        if (other instanceof NBTTagList) {
            return this.fromNative((NBTTagList)other);
        }
        if (other instanceof NBTTagEnd) {
            return this.fromNative((NBTTagEnd)other);
        }
        if (other instanceof NBTTagLong) {
            return this.fromNative((NBTTagLong)other);
        }
        if (other instanceof NBTTagString) {
            return this.fromNative((NBTTagString)other);
        }
        if (other instanceof NBTTagInt) {
            return this.fromNative((NBTTagInt)other);
        }
        if (other instanceof NBTTagByte) {
            return this.fromNative((NBTTagByte)other);
        }
        if (other instanceof NBTTagByteArray) {
            return this.fromNative((NBTTagByteArray)other);
        }
        if (other instanceof NBTTagCompound) {
            return this.fromNative((NBTTagCompound)other);
        }
        if (other instanceof NBTTagFloat) {
            return this.fromNative((NBTTagFloat)other);
        }
        if (other instanceof NBTTagShort) {
            return this.fromNative((NBTTagShort)other);
        }
        if (other instanceof NBTTagDouble) {
            return this.fromNative((NBTTagDouble)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public IntArrayTag fromNative(NBTTagIntArray other) {
        int[] value = other.getIntArray();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public ListTag fromNative(NBTTagList other) {
        other = other.copy();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = StringTag.class;
        int tags = other.tagCount();
        for (int i = 0; i < tags; ++i) {
            Tag child = this.fromNative(other.removeTag(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public EndTag fromNative(NBTTagEnd other) {
        return new EndTag();
    }

    public LongTag fromNative(NBTTagLong other) {
        return new LongTag(other.getLong());
    }

    public StringTag fromNative(NBTTagString other) {
        return new StringTag(other.getString());
    }

    public IntTag fromNative(NBTTagInt other) {
        return new IntTag(other.getInt());
    }

    public ByteTag fromNative(NBTTagByte other) {
        return new ByteTag(other.getByte());
    }

    public ByteArrayTag fromNative(NBTTagByteArray other) {
        byte[] value = other.getByteArray();
        return new ByteArrayTag(Arrays.copyOf(value, value.length));
    }

    public CompoundTag fromNative(NBTTagCompound other) {
        Set tags = other.getKeySet();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, this.fromNative(other.getTag(tagName)));
        }
        return new CompoundTag(map);
    }

    public FloatTag fromNative(NBTTagFloat other) {
        return new FloatTag(other.getFloat());
    }

    public ShortTag fromNative(NBTTagShort other) {
        return new ShortTag(other.getShort());
    }

    public DoubleTag fromNative(NBTTagDouble other) {
        return new DoubleTag(other.getDouble());
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack makeSpongeStack(BaseItemStack itemStack) {
        ItemStack newStack = new ItemStack(Item.getItemById((int)itemStack.getType()), itemStack.getAmount(), (int)itemStack.getData());
        for (Map.Entry<Integer, Integer> entry : itemStack.getEnchantments().entrySet()) {
            newStack.addEnchantment(Enchantment.getEnchantmentByID((int)entry.getKey()), entry.getValue().intValue());
        }
        return (org.spongepowered.api.item.inventory.ItemStack)newStack;
    }

    @Override
    public BaseEntity createBaseEntity(Entity entity) {
        String id = entity.getType().getId();
        NBTTagCompound tag = new NBTTagCompound();
        ((net.minecraft.entity.Entity)entity).writeToNBT(tag);
        return new BaseEntity(id, this.fromNative(tag));
    }

    @Override
    public SpongeWorld getWorld(World world) {
        return new SpongeNMSWorld(world);
    }

    @Override
    public boolean isBest() {
        return Sponge.getPlatform().getMinecraftVersion().getName().contains("1.12.2");
    }

    private class TileEntityBaseBlock
    extends BaseBlock
    implements TileEntityBlock {
        TileEntityBaseBlock(int type, int data, TileEntity tile) {
            super(type, data);
            this.setNbtData(Sponge_1_12_2_Impl.this.fromNative(this.copyNbtData(tile)));
        }

        private NBTTagCompound copyNbtData(TileEntity tile) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.writeToNBT(tag);
            return tag;
        }
    }

    private class SpongeNMSWorld
    extends SpongeWorld {
        public SpongeNMSWorld(World world) {
            super(world);
        }

        @Override
        protected BlockState getBlockState(BaseBlock block) {
            return (BlockState)Block.getBlockById((int)block.getId()).getStateFromMeta(block.getData());
        }

        private NBTTagCompound updateForSet(NBTTagCompound tag, Vector position) {
            Preconditions.checkNotNull((Object)tag);
            Preconditions.checkNotNull((Object)position);
            tag.setTag("x", (NBTBase)new NBTTagInt(position.getBlockX()));
            tag.setTag("y", (NBTBase)new NBTTagInt(position.getBlockY()));
            tag.setTag("z", (NBTBase)new NBTTagInt(position.getBlockZ()));
            return tag;
        }

        @Override
        protected void applyTileEntityData(org.spongepowered.api.block.tileentity.TileEntity entity, BaseBlock block) {
            NBTTagCompound tag = Sponge_1_12_2_Impl.this.toNative(block.getNbtData());
            Location loc = entity.getLocation();
            this.updateForSet(tag, new Vector(loc.getX(), loc.getY(), loc.getZ()));
            ((TileEntity)entity).readFromNBT(tag);
        }

        @Override
        protected void applyEntityData(Entity entity, BaseEntity data) {
            NBTTagCompound tag = Sponge_1_12_2_Impl.this.toNative(data.getNbtData());
            for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                tag.removeTag(name);
            }
            ((net.minecraft.entity.Entity)entity).readFromNBT(tag);
        }

        @Override
        public boolean clearContainerBlockContents(Vector position) {
            BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            TileEntity tile = ((net.minecraft.world.World)this.getWorld()).getTileEntity(pos);
            if (tile instanceof IInventory) {
                IInventory inv = (IInventory)tile;
                int size = inv.getSizeInventory();
                for (int i = 0; i < size; ++i) {
                    inv.setInventorySlotContents(i, ItemStack.EMPTY);
                }
                return true;
            }
            return false;
        }

        @Nullable
        private WorldGenerator createWorldGenerator(TreeGenerator.TreeType type) {
            switch (type) {
                case TREE: {
                    return new WorldGenTrees(true);
                }
                case BIG_TREE: {
                    return new WorldGenBigTree(true);
                }
                case REDWOOD: {
                    return new WorldGenTaiga2(true);
                }
                case TALL_REDWOOD: {
                    return new WorldGenTaiga1();
                }
                case BIRCH: {
                    return new WorldGenBirchTree(true, false);
                }
                case JUNGLE: {
                    return new WorldGenMegaJungle(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
                }
                case SMALL_JUNGLE: {
                    return new WorldGenTrees(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
                }
                case SHORT_JUNGLE: {
                    return new WorldGenTrees(true, 4 + ThreadLocalRandom.current().nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
                }
                case JUNGLE_BUSH: {
                    return new WorldGenShrub(JUNGLE_LOG, JUNGLE_SHRUB);
                }
                case RED_MUSHROOM: {
                    return new WorldGenBigMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
                }
                case BROWN_MUSHROOM: {
                    return new WorldGenBigMushroom(Blocks.RED_MUSHROOM_BLOCK);
                }
                case SWAMP: {
                    return new WorldGenSwamp();
                }
                case ACACIA: {
                    return new WorldGenSavannaTree(true);
                }
                case DARK_OAK: {
                    return new WorldGenCanopyTree(true);
                }
                case MEGA_REDWOOD: {
                    return new WorldGenMegaPineTree(false, ThreadLocalRandom.current().nextBoolean());
                }
                case TALL_BIRCH: {
                    return new WorldGenBirchTree(true, true);
                }
            }
            return null;
        }

        @Override
        public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pos) throws MaxChangedBlocksException {
            WorldGenerator generator = this.createWorldGenerator(type);
            return generator != null && generator.generate((net.minecraft.world.World)this.getWorld(), (Random)ThreadLocalRandom.current(), new BlockPos(pos.getX(), pos.getY(), pos.getZ()));
        }

        @Override
        public BaseBlock getBlock(Vector position) {
            World world = this.getWorld();
            BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            IBlockState state = ((net.minecraft.world.World)world).getBlockState(pos);
            TileEntity tile = ((net.minecraft.world.World)world).getTileEntity(pos);
            if (tile != null) {
                return new TileEntityBaseBlock(Block.getIdFromBlock((Block)state.getBlock()), state.getBlock().getMetaFromState(state), tile);
            }
            return new BaseBlock(Block.getIdFromBlock((Block)state.getBlock()), state.getBlock().getMetaFromState(state));
        }

        @Override
        public BaseBlock getLazyBlock(Vector position) {
            World world = this.getWorld();
            BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
            IBlockState state = ((net.minecraft.world.World)world).getBlockState(pos);
            return new LazyBlock(Block.getIdFromBlock((Block)state.getBlock()), state.getBlock().getMetaFromState(state), this, position);
        }
    }
}

