/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.config;

import com.google.common.reflect.TypeToken;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.world.snapshot.SnapshotRepository;
import java.io.IOException;
import java.util.HashSet;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.slf4j.Logger;

public class ConfigurateConfiguration
extends LocalConfiguration {
    protected final ConfigurationLoader<CommentedConfigurationNode> config;
    protected final Logger logger;
    protected CommentedConfigurationNode node;

    public ConfigurateConfiguration(ConfigurationLoader<CommentedConfigurationNode> config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    @Override
    public void load() {
        String type;
        try {
            ConfigurationOptions options = ConfigurationOptions.defaults();
            options = options.setShouldCopyDefaults(true);
            this.node = (CommentedConfigurationNode)this.config.load(options);
        }
        catch (IOException e) {
            this.logger.warn("Error loading WorldEdit configuration", (Throwable)e);
        }
        this.profile = this.node.getNode(new Object[]{"debug"}).getBoolean(this.profile);
        this.wandItem = this.node.getNode(new Object[]{"wand-item"}).getInt(this.wandItem);
        this.defaultChangeLimit = Math.max(-1, this.node.getNode(new Object[]{"limits", "max-blocks-changed", "default"}).getInt(this.defaultChangeLimit));
        this.maxChangeLimit = Math.max(-1, this.node.getNode(new Object[]{"limits", "max-blocks-changed", "maximum"}).getInt(this.maxChangeLimit));
        this.defaultMaxPolygonalPoints = Math.max(-1, this.node.getNode(new Object[]{"limits", "max-polygonal-points", "default"}).getInt(this.defaultMaxPolygonalPoints));
        this.maxPolygonalPoints = Math.max(-1, this.node.getNode(new Object[]{"limits", "max-polygonal-points", "maximum"}).getInt(this.maxPolygonalPoints));
        this.maxRadius = Math.max(-1, this.node.getNode(new Object[]{"limits", "max-radius"}).getInt(this.maxRadius));
        this.maxBrushRadius = this.node.getNode(new Object[]{"limits", "max-brush-radius"}).getInt(this.maxBrushRadius);
        this.maxSuperPickaxeSize = Math.max(1, this.node.getNode(new Object[]{"limits", "max-super-pickaxe-size"}).getInt(this.maxSuperPickaxeSize));
        this.butcherDefaultRadius = Math.max(-1, this.node.getNode(new Object[]{"limits", "butcher-radius", "default"}).getInt(this.butcherDefaultRadius));
        this.butcherMaxRadius = Math.max(-1, this.node.getNode(new Object[]{"limits", "butcher-radius", "maximum"}).getInt(this.butcherMaxRadius));
        try {
            this.disallowedBlocks = new HashSet(this.node.getNode(new Object[]{"limits", "disallowed-blocks"}).getList(TypeToken.of(Integer.class)));
        }
        catch (ObjectMappingException e) {
            this.logger.warn("Error loading WorldEdit configuration", (Throwable)e);
        }
        try {
            this.allowedDataCycleBlocks = new HashSet(this.node.getNode(new Object[]{"limits", "allowed-data-cycle-blocks"}).getList(TypeToken.of(Integer.class)));
        }
        catch (ObjectMappingException e) {
            this.logger.warn("Error loading WorldEdit configuration", (Throwable)e);
        }
        this.registerHelp = this.node.getNode(new Object[]{"register-help"}).getBoolean(true);
        this.logCommands = this.node.getNode(new Object[]{"logging", "log-commands"}).getBoolean(this.logCommands);
        this.logFile = this.node.getNode(new Object[]{"logging", "file"}).getString(this.logFile);
        this.logFormat = this.node.getNode(new Object[]{"logging", "format"}).getString(this.logFormat);
        this.superPickaxeDrop = this.node.getNode(new Object[]{"super-pickaxe", "drop-items"}).getBoolean(this.superPickaxeDrop);
        this.superPickaxeManyDrop = this.node.getNode(new Object[]{"super-pickaxe", "many-drop-items"}).getBoolean(this.superPickaxeManyDrop);
        this.noDoubleSlash = this.node.getNode(new Object[]{"no-double-slash"}).getBoolean(this.noDoubleSlash);
        this.useInventory = this.node.getNode(new Object[]{"use-inventory", "enable"}).getBoolean(this.useInventory);
        this.useInventoryOverride = this.node.getNode(new Object[]{"use-inventory", "allow-override"}).getBoolean(this.useInventoryOverride);
        this.useInventoryCreativeOverride = this.node.getNode(new Object[]{"use-inventory", "creative-mode-overrides"}).getBoolean(this.useInventoryCreativeOverride);
        this.navigationWand = this.node.getNode(new Object[]{"navigation-wand", "item"}).getInt(this.navigationWand);
        this.navigationWandMaxDistance = this.node.getNode(new Object[]{"navigation-wand", "max-distance"}).getInt(this.navigationWandMaxDistance);
        this.navigationUseGlass = this.node.getNode(new Object[]{"navigation", "use-glass"}).getBoolean(this.navigationUseGlass);
        this.scriptTimeout = this.node.getNode(new Object[]{"scripting", "timeout"}).getInt(this.scriptTimeout);
        this.scriptsDir = this.node.getNode(new Object[]{"scripting", "dir"}).getString(this.scriptsDir);
        this.saveDir = this.node.getNode(new Object[]{"saving", "dir"}).getString(this.saveDir);
        this.allowSymlinks = this.node.getNode(new Object[]{"files", "allow-symbolic-links"}).getBoolean(false);
        LocalSession.MAX_HISTORY_SIZE = Math.max(0, this.node.getNode(new Object[]{"history", "size"}).getInt(15));
        SessionManager.EXPIRATION_GRACE = this.node.getNode(new Object[]{"history", "expiration"}).getInt(10) * 60 * 1000;
        this.showHelpInfo = this.node.getNode(new Object[]{"show-help-on-first-use"}).getBoolean(true);
        String snapshotsDir = this.node.getNode(new Object[]{"snapshots", "directory"}).getString("");
        if (!snapshotsDir.isEmpty()) {
            this.snapshotRepo = new SnapshotRepository(snapshotsDir);
        }
        this.shellSaveType = (type = this.node.getNode(new Object[]{"shell-save-type"}).getString("").trim()).equals("") ? null : type;
    }
}

