/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.sponge.config;

import com.google.inject.Inject;
import com.sk89q.worldedit.sponge.SpongeWorldEdit;
import com.sk89q.worldedit.sponge.config.ConfigurateConfiguration;
import java.io.File;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.config.DefaultConfig;

public class SpongeConfiguration
extends ConfigurateConfiguration {
    public boolean creativeEnable = false;
    public boolean cheatMode = false;

    @Inject
    public SpongeConfiguration(@DefaultConfig(sharedRoot=false) ConfigurationLoader<CommentedConfigurationNode> config, Logger logger) {
        super(config, logger);
    }

    @Override
    public void load() {
        super.load();
        this.creativeEnable = this.node.getNode(new Object[]{"use-in-creative"}).getBoolean(false);
        this.cheatMode = this.node.getNode(new Object[]{"cheat-mode"}).getBoolean(false);
        try {
            this.config.save((ConfigurationNode)this.node);
        }
        catch (IOException e) {
            this.logger.warn("Error loading WorldEdit configuration", (Throwable)e);
        }
    }

    @Override
    public File getWorkingDirectory() {
        return SpongeWorldEdit.inst().getWorkingDir();
    }
}

